/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.temptable;

import java.util.function.Function;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableExporter;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class StandardTemporaryTableExporter
implements TemporaryTableExporter {
    private final Dialect dialect;

    public StandardTemporaryTableExporter(Dialect dialect) {
        this.dialect = dialect;
    }

    protected String getCreateCommand() {
        return this.dialect.getTemporaryTableCreateCommand();
    }

    protected String getCreateOptions() {
        return this.dialect.getTemporaryTableCreateOptions();
    }

    protected String getDropCommand() {
        return this.dialect.getTemporaryTableDropCommand();
    }

    protected String getTruncateTableCommand() {
        return this.dialect.getTemporaryTableTruncateCommand();
    }

    @Override
    public String getSqlCreateCommand(TemporaryTable temporaryTable) {
        StringBuilder buffer = new StringBuilder(this.getCreateCommand()).append(' ');
        buffer.append(temporaryTable.getQualifiedTableName());
        buffer.append('(');
        for (TemporaryTableColumn column : temporaryTable.getColumnsForExport()) {
            buffer.append(column.getColumnName()).append(' ');
            int sqlTypeCode = column.getJdbcMapping().getJdbcType().getDdlTypeCode();
            String databaseTypeName = column.getSqlTypeDefinition();
            buffer.append(databaseTypeName);
            String columnAnnotation = this.dialect.getCreateTemporaryTableColumnAnnotation(sqlTypeCode);
            if (!columnAnnotation.isEmpty()) {
                buffer.append(' ').append(columnAnnotation);
            }
            if (column.isNullable()) {
                String nullColumnString = this.dialect.getNullColumnString(databaseTypeName);
                if (!databaseTypeName.contains(nullColumnString)) {
                    buffer.append(nullColumnString);
                }
            } else {
                buffer.append(" not null");
            }
            buffer.append(", ");
        }
        if (this.dialect.supportsTemporaryTablePrimaryKey()) {
            buffer.append("primary key (");
            for (TemporaryTableColumn column : temporaryTable.getColumnsForExport()) {
                if (!column.isPrimaryKey()) continue;
                buffer.append(column.getColumnName());
                buffer.append(", ");
            }
            buffer.setLength(buffer.length() - 2);
            buffer.append(')');
        } else {
            buffer.setLength(buffer.length() - 2);
        }
        buffer.append(')');
        String createOptions = this.getCreateOptions();
        if (createOptions != null) {
            buffer.append(' ').append(createOptions);
        }
        return buffer.toString();
    }

    @Override
    public String getSqlDropCommand(TemporaryTable idTable) {
        return this.getDropCommand() + " " + idTable.getQualifiedTableName();
    }

    @Override
    public String getSqlTruncateCommand(TemporaryTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, SharedSessionContractImplementor session) {
        if (idTable.getSessionUidColumn() != null) {
            ParameterMarkerStrategy parameterMarkerStrategy = session.getSessionFactory().getFastSessionServices().parameterMarkerStrategy;
            return this.getTruncateTableCommand() + " " + idTable.getQualifiedTableName() + " where " + idTable.getSessionUidColumn().getColumnName() + " = " + parameterMarkerStrategy.createMarker(1, null);
        }
        return this.getTruncateTableCommand() + " " + idTable.getQualifiedTableName();
    }
}

