/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.validation.Validation;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class UsernameIDNHomographValidator
implements SimpleValidator,
ConfiguredProvider {
    public static final String ID = "up-username-not-idn-homograph";
    public static final String CFG_ERROR_MESSAGE = "error-message";
    public static final String MESSAGE_NO_MATCH = "error-username-invalid-character";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values = (List)input;
        String value = null;
        if (values != null && !values.isEmpty()) {
            value = (String)values.get(0);
        }
        if (!Validation.isBlank(value) && !Validation.isUsernameValid(value)) {
            context.addError(new ValidationError(ID, inputHint, this.getErrorMessageKey(inputHint, config)));
        }
        return context;
    }

    protected String getErrorMessageKey(String inputHint, ValidatorConfig config) {
        String cfg = config.getString(CFG_ERROR_MESSAGE);
        return cfg != null && !cfg.isBlank() ? cfg : MESSAGE_NO_MATCH;
    }

    public String getHelpText() {
        return "The field can contain only latin characters and common unicode characters. Useful for the fields, which can be subject of IDN homograph attacks (typically username).";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(CFG_ERROR_MESSAGE);
        property.setLabel("Error message key");
        property.setHelpText("Key of the error message in i18n bundle. Default message key is error-username-invalid-character");
        property.setType("String");
        configProperties.add(property);
    }
}

