/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.theme.FolderTheme;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;

public class FolderThemeProvider
implements ThemeProvider {
    private final File themesDir;

    public FolderThemeProvider(File themesDir) {
        this.themesDir = themesDir;
    }

    public int getProviderPriority() {
        return 100;
    }

    public Theme getTheme(String name, Theme.Type type) throws IOException {
        File themeDir = this.getThemeDir(name, type);
        return themeDir != null ? new FolderTheme(themeDir, name, type) : null;
    }

    public Set<String> nameSet(Theme.Type type) {
        if (this.themesDir == null || !this.themesDir.isDirectory()) {
            return Collections.emptySet();
        }
        File[] themes = this.themesDir.listFiles(f -> f.isDirectory() && new File(f, type.name().toLowerCase()).isDirectory());
        if (themes != null && themes.length > 0) {
            HashSet<String> names = new HashSet<String>();
            for (File themeDir : themes) {
                names.add(themeDir.getName());
            }
            return names;
        }
        return Collections.emptySet();
    }

    public boolean hasTheme(String name, Theme.Type type) {
        return this.getThemeDir(name, type) != null;
    }

    public void close() {
    }

    private File getThemeDir(String name, Theme.Type type) {
        File themeTypeDir;
        if (this.themesDir == null || !this.themesDir.isDirectory()) {
            return null;
        }
        File[] themes = this.themesDir.listFiles(f -> f.isDirectory() && f.getName().equals(name));
        if (themes != null && themes.length == 1 && (themeTypeDir = new File(themes[0], type.name().toLowerCase())).isDirectory()) {
            return themeTypeDir;
        }
        return null;
    }
}

