/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.clientpolicy.executor;

import jakarta.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.context.BackchannelAuthenticationRequestContext;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.request.BackchannelAuthenticationEndpointRequest;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureCibaSessionEnforceExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    private static final Logger logger = Logger.getLogger(SecureCibaSessionEnforceExecutor.class);
    private final KeycloakSession session;

    public SecureCibaSessionEnforceExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-ciba-session";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case BACKCHANNEL_AUTHENTICATION_REQUEST: {
                BackchannelAuthenticationRequestContext backchannelAuthenticationRequestContext = (BackchannelAuthenticationRequestContext)context;
                this.executeOnBackchannelAuthenticationRequest(backchannelAuthenticationRequestContext.getRequest(), backchannelAuthenticationRequestContext.getRequestParameters());
                return;
            }
        }
    }

    private void executeOnBackchannelAuthenticationRequest(BackchannelAuthenticationEndpointRequest request, MultivaluedMap<String, String> requestParameters) throws ClientPolicyException {
        logger.trace((Object)"Backchannel Authentication Endpoint - authn request");
        if (request.getBindingMessage() == null) {
            logger.trace((Object)"Missing parameter: binding_message");
            throw new ClientPolicyException("invalid_request", "Missing parameter: binding_message");
        }
        logger.trace((Object)"Passed.");
    }
}

