/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.utils.JWKSHttpUtils;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.services.util.CertificateInfoHelper;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;

public class ClientPublicKeyLoader
implements PublicKeyLoader {
    private static final Logger logger = Logger.getLogger(ClientPublicKeyLoader.class);
    private final KeycloakSession session;
    private final ClientModel client;
    private final JWK.Use keyUse;

    public ClientPublicKeyLoader(KeycloakSession session, ClientModel client) {
        this.session = session;
        this.client = client;
        this.keyUse = JWK.Use.SIG;
    }

    public ClientPublicKeyLoader(KeycloakSession session, ClientModel client, JWK.Use keyUse) {
        this.session = session;
        this.client = client;
        this.keyUse = keyUse;
    }

    public PublicKeysWrapper loadKeys() throws Exception {
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientModel(this.client);
        if (config.isUseJwksUrl()) {
            String jwksUrl = config.getJwksUrl();
            jwksUrl = ResolveRelative.resolveRelativeUri(this.session, this.client.getRootUrl(), jwksUrl);
            JSONWebKeySet jwks = JWKSHttpUtils.sendJwksRequest(this.session, jwksUrl);
            return JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)this.keyUse, (boolean)true);
        }
        if (config.isUseJwksString()) {
            JSONWebKeySet jwks = (JSONWebKeySet)JsonSerialization.readValue((String)config.getJwksString(), JSONWebKeySet.class);
            return JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)this.keyUse);
        }
        if (this.keyUse == JWK.Use.SIG) {
            try {
                CertificateRepresentation certInfo = CertificateInfoHelper.getCertificateFromClient(this.client, "jwt.credential");
                KeyWrapper publicKey = ClientPublicKeyLoader.getSignatureValidationKey(certInfo);
                return new PublicKeysWrapper(Collections.singletonList(publicKey));
            }
            catch (ModelException me) {
                logger.warnf((Throwable)me, "Unable to retrieve publicKey for verify signature of client '%s' . Error details: %s", (Object)this.client.getClientId(), (Object)me.getMessage());
                return PublicKeysWrapper.EMPTY;
            }
        }
        logger.warnf("Unable to retrieve publicKey of client '%s' for the specified purpose other than verifying signature", (Object)this.client.getClientId());
        return PublicKeysWrapper.EMPTY;
    }

    private static KeyWrapper getSignatureValidationKey(CertificateRepresentation certInfo) throws ModelException {
        KeyWrapper keyWrapper = new KeyWrapper();
        String encodedCertificate = certInfo.getCertificate();
        String encodedPublicKey = certInfo.getPublicKey();
        if (encodedCertificate == null && encodedPublicKey == null) {
            throw new ModelException("Client doesn't have certificate or publicKey configured");
        }
        if (encodedCertificate != null && encodedPublicKey != null) {
            throw new ModelException("Client has both publicKey and certificate configured");
        }
        keyWrapper.setUse(KeyUse.SIG);
        String kid = null;
        if (encodedCertificate != null) {
            X509Certificate clientCert = KeycloakModelUtils.getCertificate((String)encodedCertificate);
            kid = certInfo.getKid() != null ? certInfo.getKid() : KeyUtils.createKeyId((Key)clientCert.getPublicKey());
            keyWrapper.setKid(kid);
            keyWrapper.setPublicKey((Key)clientCert.getPublicKey());
            keyWrapper.setType(clientCert.getPublicKey().getAlgorithm());
            keyWrapper.setCertificate(clientCert);
            keyWrapper.setIsDefaultClientCertificate(true);
        } else {
            PublicKey publicKey = KeycloakModelUtils.getPublicKey((String)encodedPublicKey);
            kid = certInfo.getKid() != null ? certInfo.getKid() : KeyUtils.createKeyId((Key)publicKey);
            keyWrapper.setKid(kid);
            keyWrapper.setPublicKey((Key)publicKey);
            keyWrapper.setType(publicKey.getAlgorithm());
        }
        return keyWrapper;
    }
}

