/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.AsymmetricSignatureVerifierContext;
import org.keycloak.crypto.ECDSAAlgorithm;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerAsymmetricSignatureVerifierContext;
import org.keycloak.models.KeycloakSession;

public class ServerECDSASignatureVerifierContext
extends AsymmetricSignatureVerifierContext {
    public ServerECDSASignatureVerifierContext(KeycloakSession session, String kid, String algorithm) throws VerificationException {
        super(ServerAsymmetricSignatureVerifierContext.getKey(session, kid, algorithm));
    }

    public ServerECDSASignatureVerifierContext(KeyWrapper key) {
        super(key);
    }

    public boolean verify(byte[] data, byte[] signature) throws VerificationException {
        try {
            int expectedSize = ECDSAAlgorithm.getSignatureLength((String)this.getAlgorithm());
            byte[] derSignature = ECDSAAlgorithm.concatenatedRSToASN1DER((byte[])signature, (int)expectedSize);
            return super.verify(data, derSignature);
        }
        catch (Exception e) {
            throw new VerificationException("Signing failed", (Throwable)e);
        }
    }
}

