/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.concurrent.Executor;

public class UniEmitOn<I>
extends UniOperator<I, I> {
    private final Executor executor;

    public UniEmitOn(Uni<I> upstream, Executor executor) {
        super(upstream);
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    public void subscribe(UniSubscriber<? super I> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniEmitOnProcessor(subscriber));
    }

    private class UniEmitOnProcessor
    extends UniOperatorProcessor<I, I> {
        public UniEmitOnProcessor(UniSubscriber<? super I> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(I item) {
            if (!this.isCancelled()) {
                UniEmitOn.this.executor.execute(() -> this.downstream.onItem(item));
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isCancelled()) {
                UniEmitOn.this.executor.execute(() -> this.downstream.onFailure(failure));
            }
        }
    }
}

