/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.List;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.LDAPConfigDecorator;
import org.keycloak.storage.ldap.mappers.UserAttributeLDAPStorageMapper;

public class UserAttributeLDAPStorageMapperFactory
extends AbstractLDAPStorageMapperFactory
implements LDAPConfigDecorator {
    public static final String PROVIDER_ID = "user-attribute-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties;

    static List<ProviderConfigProperty> getConfigProps(ComponentModel p) {
        String readOnly = "false";
        UserStorageProviderModel parent = new UserStorageProviderModel();
        if (p != null) {
            parent = new UserStorageProviderModel(p);
            LDAPConfig ldapConfig = new LDAPConfig((MultivaluedHashMap<String, String>)parent.getConfig());
            readOnly = ldapConfig.getEditMode() == UserStorageProvider.EditMode.WRITABLE ? "false" : "true";
        }
        ProviderConfigurationBuilder config = ProviderConfigurationBuilder.create().property().name("user.model.attribute").label("User Model Attribute").helpText("Name of the UserModel property or attribute you want to map the LDAP attribute into. For example 'firstName', 'lastName, 'email', 'street' etc.").type("UserProfileAttributeList").required(true).add().property().name("ldap.attribute").label("LDAP Attribute").helpText("Name of mapped attribute on LDAP object. For example 'cn', 'sn, 'mail', 'street' etc.").type("String").required(true).add().property().name("read.only").label("Read Only").helpText("Read-only attribute is imported from LDAP to UserModel, but it's not saved back to LDAP when user is updated in Keycloak.").type("boolean").defaultValue((Object)readOnly).add();
        if (parent.isImportEnabled()) {
            config.property().name("always.read.value.from.ldap").label("Always Read Value From LDAP").helpText("If on, then during reading of the LDAP attribute value will always used instead of the value from Keycloak DB").type("boolean").defaultValue((Object)"false").add();
        }
        config.property().name("is.mandatory.in.ldap").label("Is Mandatory In LDAP").helpText("If true, attribute is mandatory in LDAP. When an attribute is mandatory the options attribute default value and force a default value apply to this mapper.").type("boolean").defaultValue((Object)"false").add().property().name("attribute.default.value").label("Attribute default value").helpText("If there is no value in Keycloak DB and attribute is mandatory in LDAP, this value will be propagated to LDAP").type("String").defaultValue((Object)"").add().property().name("attribute.force.default").label("Force a Default Value").helpText("If true a empty default value is forced for mandatory attributes even when a default value is not specified. If false the mandatory attribute needs to be manually set during the transaction when the default value option is not configured.").type("boolean").defaultValue((Object)"true").add().property().name("is.binary.attribute").label("Is Binary Attribute").helpText("Should be true for binary LDAP attributes").type("boolean").defaultValue((Object)"false").add();
        return config.build();
    }

    @Override
    public String getHelpText() {
        return "Used to map single attribute from LDAP user to attribute of UserModel in Keycloak DB";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        this.checkMandatoryConfigAttribute("user.model.attribute", "User Model Attribute", config);
        this.checkMandatoryConfigAttribute("ldap.attribute", "LDAP Attribute", config);
        boolean isBinaryAttribute = config.get("is.binary.attribute", false);
        boolean alwaysReadValueFromLDAP = config.get("always.read.value.from.ldap", false);
        if (isBinaryAttribute && !alwaysReadValueFromLDAP) {
            throw new ComponentValidationException("With Binary attribute enabled, the ''Always read value from LDAP'' must be enabled too", new Object[0]);
        }
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new UserAttributeLDAPStorageMapper(mapperModel, federationProvider);
    }

    public List<ProviderConfigProperty> getConfigProperties(RealmModel realm, ComponentModel parent) {
        return UserAttributeLDAPStorageMapperFactory.getConfigProps(parent);
    }

    @Override
    public void updateLDAPConfig(LDAPConfig ldapConfig, ComponentModel mapperModel) {
        boolean isBinaryAttribute = mapperModel.get("is.binary.attribute", false);
        if (isBinaryAttribute) {
            String ldapAttrName = (String)mapperModel.getConfig().getFirst((Object)"ldap.attribute");
            ldapConfig.addBinaryAttribute(ldapAttrName);
        }
    }

    static {
        List<ProviderConfigProperty> props = UserAttributeLDAPStorageMapperFactory.getConfigProps(null);
        configProperties = props;
    }
}

