/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import org.keycloak.models.RealmModel;

public interface Theme {
    public static final String ACCOUNT_RESOURCE_PROVIDER_KEY = "accountResourceProvider";
    public static final String CONTENT_HASH_PATTERN = "contentHashPattern";

    public String getName();

    public String getParentName();

    public String getImportName();

    public Type getType();

    public URL getTemplate(String var1) throws IOException;

    public InputStream getResourceAsStream(String var1) throws IOException;

    public Properties getMessages(Locale var1) throws IOException;

    public Properties getMessages(String var1, Locale var2) throws IOException;

    public Properties getEnhancedMessages(RealmModel var1, Locale var2) throws IOException;

    public Properties getProperties() throws IOException;

    default public boolean hasContentHash(String path) throws IOException {
        Object contentHashPattern = this.getProperties().get(CONTENT_HASH_PATTERN);
        if (contentHashPattern != null) {
            return path.matches(contentHashPattern.toString());
        }
        return false;
    }

    public static enum Type {
        LOGIN,
        ACCOUNT,
        ADMIN,
        EMAIL,
        WELCOME,
        COMMON;

    }
}

