/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import java.util.HashSet;
import java.util.function.IntFunction;

public final class HashSetFactory<T>
implements IntFunction<HashSet<T>> {
    private static final HashSetFactory<?> INSTANCE = new HashSetFactory();

    private HashSetFactory() {
    }

    @Override
    public HashSet<T> apply(int value) {
        return new HashSet(this.getInitialCapacityFromExpectedSize(value));
    }

    private int getInitialCapacityFromExpectedSize(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        return (int)((float)expectedSize / 0.75f + 1.0f);
    }

    public static <T> HashSetFactory<T> getInstance() {
        return INSTANCE;
    }
}

