/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.reflection;

import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.core.reflection.ReflectionConstructorParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.reflection.ReflectionValueOfParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.processor.ServerEndpointIndexer;

public class ReflectionConverterIndexerExtension
implements ServerEndpointIndexer.ConverterSupplierIndexerExtension {
    @Override
    public ParameterConverterSupplier extractConverterImpl(String elementType, IndexView indexView, Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters) {
        MethodInfo fromString = null;
        MethodInfo valueOf = null;
        MethodInfo stringCtor = null;
        String primitiveWrapperType = (String)EndpointIndexer.primitiveTypes.get(elementType);
        String prefix = "";
        if (primitiveWrapperType != null) {
            return new ReflectionValueOfParameterConverterSupplier(primitiveWrapperType);
        }
        ClassInfo type = indexView.getClassByName(DotName.createSimple((String)elementType));
        if (type != null) {
            for (MethodInfo i : type.methods()) {
                boolean isNotPrivate;
                boolean isStatic = (i.flags() & 8) != 0;
                boolean bl = isNotPrivate = (i.flags() & 2) == 0;
                if (i.parametersCount() != 1 || !isNotPrivate || !i.parameterType(0).name().equals((Object)ResteasyReactiveDotNames.STRING)) continue;
                if (i.name().equals("<init>")) {
                    stringCtor = i;
                    continue;
                }
                if (i.name().equals("valueOf") && isStatic) {
                    valueOf = i;
                    continue;
                }
                if (!i.name().equals("fromString") || !isStatic) continue;
                fromString = i;
            }
            if (type.isEnum() && fromString != null) {
                valueOf = null;
            }
        }
        ReflectionConstructorParameterConverterSupplier delegate = null;
        if (stringCtor != null) {
            delegate = new ReflectionConstructorParameterConverterSupplier(stringCtor.declaringClass().name().toString());
        } else if (valueOf != null) {
            delegate = new ReflectionValueOfParameterConverterSupplier(valueOf.declaringClass().name().toString());
        } else if (fromString != null) {
            delegate = new ReflectionValueOfParameterConverterSupplier(fromString.declaringClass().name().toString(), "fromString");
        }
        if (hasRuntimeConverters) {
            return new RuntimeResolvedConverter.Supplier().setDelegate((ParameterConverterSupplier)delegate);
        }
        if (delegate == null) {
            throw new RuntimeException("Failed to find converter for " + elementType);
        }
        return delegate;
    }
}

