/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.internal.JsonTreeInput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0014J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkotlinx/serialization/json/internal/JsonTreeMapInput;", "Lkotlinx/serialization/json/internal/JsonTreeInput;", "json", "Lkotlinx/serialization/json/Json;", "obj", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;)V", "keys", "", "", "getObj", "()Lkotlinx/serialization/json/JsonObject;", "position", "", "size", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "tag", "decodeElementIndex", "desc", "Lkotlinx/serialization/SerialDescriptor;", "elementName", "index", "endStructure", "", "kotlinx-serialization-runtime"})
final class JsonTreeMapInput
extends JsonTreeInput {
    private final List<String> keys;
    private final int size;
    private int position;
    @NotNull
    private final JsonObject obj;

    @Override
    @NotNull
    public String elementName(@NotNull SerialDescriptor desc, int index) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        int i = index / 2;
        return this.keys.get(i);
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        if (this.position < this.size - 1) {
            int n = this.position;
            this.position = n + 1;
            return this.position;
        }
        return -1;
    }

    @Override
    @NotNull
    protected JsonElement currentElement(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        return this.position % 2 == 0 ? (JsonElement)new JsonLiteral(tag) : (JsonElement)MapsKt.getValue((Map)this.getObj(), (Object)tag);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
    }

    @Override
    @NotNull
    public JsonObject getObj() {
        return this.obj;
    }

    public JsonTreeMapInput(@NotNull Json json, @NotNull JsonObject obj) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        super(json, obj);
        this.obj = obj;
        this.keys = CollectionsKt.toList((Iterable)this.getObj().keySet());
        this.size = this.keys.size() * 2;
        this.position = -1;
    }
}

