/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.Brackets;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryInfoCache;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryReferenceParser;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolutionInfoParser;
import org.jetbrains.kotlinx.jupyter.libraries.Parameter;
import org.jetbrains.kotlinx.jupyter.libraries.UtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParserImpl;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParser;", "libraryInfoCache", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryInfoCache;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryInfoCache;)V", "parseReferenceWithArgs", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "string", "", "parseLibraryReference", "parseResolutionInfo", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionInfo;", "defaultParsers", "", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolutionInfoParser;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nLibraryReferenceParserImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryReferenceParserImpl.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParserImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1208#2,2:57\n1236#2,4:59\n774#2:63\n865#2,2:64\n*S KotlinDebug\n*F\n+ 1 LibraryReferenceParserImpl.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParserImpl\n*L\n54#1:57,2\n54#1:59,4\n15#1:63\n15#1:64,2\n*E\n"})
public final class LibraryReferenceParserImpl
implements LibraryReferenceParser {
    @NotNull
    private final LibraryInfoCache libraryInfoCache;
    @NotNull
    private final Map<String, LibraryResolutionInfoParser> defaultParsers;

    /*
     * WARNING - void declaration
     */
    public LibraryReferenceParserImpl(@NotNull LibraryInfoCache libraryInfoCache) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)libraryInfoCache, (String)"libraryInfoCache");
        this.libraryInfoCache = libraryInfoCache;
        Object object = new LibraryResolutionInfoParser[]{LibraryResolutionInfoParser.Companion.make("ref", CollectionsKt.listOf((Object)new Parameter.Required("ref")), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)arg_0 -> LibraryReferenceParserImpl.defaultParsers$lambda$0(this, arg_0))), LibraryResolutionInfoParser.Companion.make("file", CollectionsKt.listOf((Object)new Parameter.Required("path")), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)LibraryReferenceParserImpl::defaultParsers$lambda$1)), LibraryResolutionInfoParser.Companion.make("dir", CollectionsKt.listOf((Object)new Parameter.Required("dir")), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)LibraryReferenceParserImpl::defaultParsers$lambda$2)), LibraryResolutionInfoParser.Companion.make("url", CollectionsKt.listOf((Object)new Parameter.Required("url")), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)LibraryReferenceParserImpl::defaultParsers$lambda$3)), LibraryResolutionInfoParser.Companion.make("classpath", CollectionsKt.emptyList(), (Function1<? super Map<String, String>, ? extends LibraryResolutionInfo>)((Function1)LibraryReferenceParserImpl::defaultParsers$lambda$4))};
        object = CollectionsKt.listOf((Object[])object);
        LibraryReferenceParserImpl libraryReferenceParserImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LibraryResolutionInfoParser libraryResolutionInfoParser = (LibraryResolutionInfoParser)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        libraryReferenceParserImpl.defaultParsers = destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<LibraryReference, List<Variable>> parseReferenceWithArgs(@NotNull String string) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Pair<String, List<Variable>> pair2 = UtilKt.parseLibraryName(string);
        String fullName = (String)pair2.component1();
        List vars = (List)pair2.component2();
        LibraryReference reference = this.parseLibraryReference(fullName);
        Iterable $this$filter$iv = vars;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Variable it = (Variable)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)it.getName()) || !StringsKt.isBlank((CharSequence)it.getValue()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List processedVars = (List)destination$iv$iv;
        return TuplesKt.to((Object)reference, (Object)processedVars);
    }

    @Override
    @NotNull
    public LibraryReference parseLibraryReference(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int sepIndex = StringsKt.indexOf$default((CharSequence)string, (char)'@', (int)0, (boolean)false, (int)6, null);
        if (sepIndex == -1) {
            return new LibraryReference(new AbstractLibraryResolutionInfo.Default(null, 1, null), string);
        }
        String string2 = string.substring(0, sepIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String nameString = string2;
        String string3 = string.substring(sepIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String infoString = string3;
        LibraryResolutionInfo info = this.parseResolutionInfo(infoString);
        return new LibraryReference(info, nameString);
    }

    private final LibraryResolutionInfo parseResolutionInfo(String string) {
        if (StringsKt.isBlank((CharSequence)string)) {
            return new AbstractLibraryResolutionInfo.Default(null, 1, null);
        }
        Pair<String, List<Variable>> pair2 = UtilKt.parseCall(string, Brackets.Companion.getSQUARE());
        String type2 = (String)pair2.component1();
        List vars = (List)pair2.component2();
        Object object = this.defaultParsers.get(type2);
        if (object == null || (object = ((LibraryResolutionInfoParser)object).getInfo(vars)) == null) {
            object = new AbstractLibraryResolutionInfo.Default(type2);
        }
        return object;
    }

    private static final LibraryResolutionInfo defaultParsers$lambda$0(LibraryReferenceParserImpl this$0, Map args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = (String)args.get("ref");
        if (string == null) {
            throw new IllegalStateException("Argument 'ref' should be specified".toString());
        }
        return this$0.libraryInfoCache.getLibraryInfoByRef(string);
    }

    private static final LibraryResolutionInfo defaultParsers$lambda$1(Map args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = (String)args.get("path");
        if (string == null) {
            throw new IllegalStateException("Argument 'path' should be specified".toString());
        }
        return new AbstractLibraryResolutionInfo.ByFile(new File(string));
    }

    private static final LibraryResolutionInfo defaultParsers$lambda$2(Map args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = (String)args.get("dir");
        if (string == null) {
            throw new IllegalStateException("Argument 'dir' should be specified".toString());
        }
        return new AbstractLibraryResolutionInfo.ByDir(new File(string));
    }

    private static final LibraryResolutionInfo defaultParsers$lambda$3(Map args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = (String)args.get("url");
        if (string == null) {
            throw new IllegalStateException("Argument 'url' should be specified".toString());
        }
        return new AbstractLibraryResolutionInfo.ByURL(new URL(string));
    }

    private static final LibraryResolutionInfo defaultParsers$lambda$4(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AbstractLibraryResolutionInfo.ByClasspath.INSTANCE;
    }
}

