/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DeleteTopicsResponse;

public class DeleteTopicsRequest
extends AbstractRequest {
    private final DeleteTopicsRequestData data;

    private DeleteTopicsRequest(DeleteTopicsRequestData data, short version) {
        super(ApiKeys.DELETE_TOPICS, version);
        this.data = data;
    }

    @Override
    public DeleteTopicsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        DeleteTopicsResponseData response = new DeleteTopicsResponseData();
        if (this.version() >= 1) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        ApiError apiError = ApiError.fromThrowable(e);
        for (DeleteTopicsRequestData.DeleteTopicState topic : this.topics()) {
            response.responses().add(new DeleteTopicsResponseData.DeletableTopicResult().setName(topic.name()).setTopicId(topic.topicId()).setErrorCode(apiError.error().code()));
        }
        return new DeleteTopicsResponse(response);
    }

    public List<String> topicNames() {
        if (this.version() >= 6) {
            return this.data.topics().stream().map(DeleteTopicsRequestData.DeleteTopicState::name).collect(Collectors.toList());
        }
        return this.data.topicNames();
    }

    public int numberOfTopics() {
        if (this.version() >= 6) {
            return this.data.topics().size();
        }
        return this.data.topicNames().size();
    }

    public List<Uuid> topicIds() {
        if (this.version() >= 6) {
            return this.data.topics().stream().map(DeleteTopicsRequestData.DeleteTopicState::topicId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<DeleteTopicsRequestData.DeleteTopicState> topics() {
        if (this.version() >= 6) {
            return this.data.topics();
        }
        return this.data.topicNames().stream().map(name -> new DeleteTopicsRequestData.DeleteTopicState().setName((String)name)).collect(Collectors.toList());
    }

    public static DeleteTopicsRequest parse(Readable readable, short version) {
        return new DeleteTopicsRequest(new DeleteTopicsRequestData(readable, version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteTopicsRequest> {
        private final DeleteTopicsRequestData data;

        public Builder(DeleteTopicsRequestData data) {
            super(ApiKeys.DELETE_TOPICS);
            this.data = data;
        }

        @Override
        public DeleteTopicsRequest build(short version) {
            if (version >= 6 && !this.data.topicNames().isEmpty()) {
                this.data.setTopics(this.groupByTopic(this.data.topicNames()));
            }
            return new DeleteTopicsRequest(this.data, version);
        }

        private List<DeleteTopicsRequestData.DeleteTopicState> groupByTopic(List<String> topics) {
            ArrayList<DeleteTopicsRequestData.DeleteTopicState> topicStates = new ArrayList<DeleteTopicsRequestData.DeleteTopicState>();
            for (String topic : topics) {
                topicStates.add(new DeleteTopicsRequestData.DeleteTopicState().setName(topic));
            }
            return topicStates;
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

