/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;

public class SessionCookieOptions {
    private final long expiresIn;

    private SessionCookieOptions(Builder builder) {
        Preconditions.checkArgument((builder.expiresIn > TimeUnit.MINUTES.toMillis(5L) ? 1 : 0) != 0, (Object)"expiresIn duration must be at least 5 minutes");
        Preconditions.checkArgument((builder.expiresIn < TimeUnit.DAYS.toMillis(14L) ? 1 : 0) != 0, (Object)"expiresIn duration must be at most 14 days");
        this.expiresIn = builder.expiresIn;
    }

    long getExpiresInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.expiresIn);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long expiresIn;

        private Builder() {
        }

        public Builder setExpiresIn(long expiresInMillis) {
            this.expiresIn = expiresInMillis;
            return this;
        }

        public SessionCookieOptions build() {
            return new SessionCookieOptions(this);
        }
    }
}

