/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.disconnect;

import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientConnectionConfig;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.MqttConnectionAwareHandler;
import com.hivemq.client.internal.mqtt.handler.MqttSession;
import com.hivemq.client.internal.mqtt.handler.connect.MqttConnAckSingle;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnectBuilder;
import com.hivemq.client.internal.rx.CompletableFlow;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.exceptions.ConnectionClosedException;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt5.auth.Mqtt5EnhancedAuthMechanism;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5ConnAckException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5DisconnectException;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConnectionScope
public class MqttDisconnectHandler
extends MqttConnectionAwareHandler {
    @NotNull
    public static final String NAME = "disconnect";
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(MqttDisconnectHandler.class);
    @NotNull
    private static final Object STATE_CLOSED = new Object();
    private static final int DISCONNECT_TIMEOUT = 10;
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttSession session;
    @Nullable
    private Object state = null;

    @Inject
    MqttDisconnectHandler(@NotNull MqttClientConfig clientConfig, @NotNull MqttSession session) {
        this.clientConfig = clientConfig;
        this.session = session;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttDisconnect) {
            this.readDisconnect(ctx, (MqttDisconnect)msg);
        } else if (msg instanceof MqttConnAck) {
            this.readConnAck(ctx, (MqttConnAck)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnect disconnect) {
        if (this.state == null) {
            this.state = STATE_CLOSED;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new Mqtt5DisconnectException((Mqtt5Disconnect)disconnect, "Server sent DISCONNECT."), MqttDisconnectSource.SERVER);
        }
    }

    private void readConnAck(@NotNull ChannelHandlerContext ctx, @NotNull MqttConnAck connAck) {
        if (this.state == null) {
            this.state = STATE_CLOSED;
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5ConnAckException(connAck, "Must not receive second CONNACK."));
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
        if (this.state == null) {
            this.state = STATE_CLOSED;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new ConnectionClosedException("Server closed connection without DISCONNECT."), MqttDisconnectSource.SERVER);
        } else if (this.state instanceof DisconnectingState) {
            DisconnectingState disconnectingState = (DisconnectingState)this.state;
            this.state = STATE_CLOSED;
            disconnectingState.timeoutFuture.cancel(false);
            this.disconnected(disconnectingState.channel, disconnectingState.disconnectEvent);
            disconnectingState.disconnectEvent.getFlow().onComplete();
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        if (this.state == null) {
            this.state = STATE_CLOSED;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new ConnectionClosedException(cause), MqttDisconnectSource.CLIENT);
        } else if (!(cause instanceof IOException)) {
            LOGGER.warn("Exception while disconnecting: {}", cause);
        }
    }

    public void disconnect(@NotNull MqttDisconnect disconnect, @NotNull CompletableFlow flow) {
        if (!this.clientConfig.executeInEventLoop(() -> this.writeDisconnect(disconnect, flow))) {
            flow.onError(MqttClientStateExceptions.notConnected());
        }
    }

    private void writeDisconnect(@NotNull MqttDisconnect disconnect, @NotNull CompletableFlow flow) {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx != null && this.state == null) {
            this.state = STATE_CLOSED;
            MqttDisconnectUtil.fireDisconnectEvent(ctx.channel(), new MqttDisconnectEvent.ByUser(disconnect, flow));
        } else {
            flow.onError(MqttClientStateExceptions.notConnected());
        }
    }

    @Override
    protected void onDisconnectEvent(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnectEvent disconnectEvent) {
        this.state = STATE_CLOSED;
        Channel channel = ctx.channel();
        if (disconnectEvent.getSource() == MqttDisconnectSource.SERVER) {
            this.disconnected(channel, disconnectEvent);
            channel.close();
            return;
        }
        Mqtt5Disconnect disconnect = disconnectEvent.getDisconnect();
        if (disconnect != null) {
            MqttClientConnectionConfig connectionConfig;
            long sessionExpiryInterval = disconnect.getRawSessionExpiryInterval();
            if (sessionExpiryInterval != -1L && (connectionConfig = this.clientConfig.getRawConnectionConfig()) != null) {
                if (sessionExpiryInterval > 0L && connectionConfig.isCleanStop()) {
                    LOGGER.warn("Session expiry interval must not be set in DISCONNECT if it was set to 0 in CONNECT");
                    disconnect = ((MqttDisconnectBuilder.Default)disconnect.extend().sessionExpiryInterval(0L)).build();
                } else {
                    connectionConfig.setSessionExpiryInterval(sessionExpiryInterval);
                }
            }
            if (disconnectEvent instanceof MqttDisconnectEvent.ByUser) {
                MqttDisconnectEvent.ByUser disconnectEventByUser = (MqttDisconnectEvent.ByUser)disconnectEvent;
                ctx.writeAndFlush((Object)disconnect).addListener(f -> {
                    if (f.isSuccess()) {
                        ((DuplexChannel)channel).shutdownOutput().addListener(cf -> {
                            if (cf.isSuccess()) {
                                this.state = new DisconnectingState(channel, disconnectEventByUser);
                            } else {
                                this.disconnected(channel, disconnectEvent);
                                disconnectEventByUser.getFlow().onError(new ConnectionClosedException(cf.cause()));
                            }
                        });
                    } else {
                        this.disconnected(channel, disconnectEvent);
                        disconnectEventByUser.getFlow().onError(new ConnectionClosedException(f.cause()));
                    }
                });
            } else if (this.clientConfig.getMqttVersion() == MqttVersion.MQTT_5_0) {
                ctx.writeAndFlush((Object)disconnect).addListener(f -> channel.close().addListener(cf -> this.disconnected(channel, disconnectEvent)));
            } else {
                channel.close().addListener(cf -> this.disconnected(channel, disconnectEvent));
            }
        } else {
            channel.close().addListener(cf -> this.disconnected(channel, disconnectEvent));
        }
    }

    private void disconnected(@NotNull Channel channel, @NotNull MqttDisconnectEvent disconnectEvent) {
        MqttClientConnectionConfig connectionConfig = this.clientConfig.getRawConnectionConfig();
        if (connectionConfig != null) {
            this.session.expire(disconnectEvent.getCause(), connectionConfig, channel.eventLoop());
            this.reconnect(disconnectEvent, connectionConfig, channel.eventLoop());
            this.clientConfig.setConnectionConfig(null);
        }
    }

    private void reconnect(@NotNull MqttDisconnectEvent disconnectEvent, @NotNull MqttClientConnectionConfig connectionConfig, @NotNull EventLoop eventLoop) {
        MqttClientConfig.ConnectDefaults connectDefaults = this.clientConfig.getConnectDefaults();
        Mqtt5EnhancedAuthMechanism enhancedAuthMechanism = connectionConfig.getRawEnhancedAuthMechanism();
        MqttConnect connect = new MqttConnect(connectionConfig.getKeepAlive(), connectionConfig.getSessionExpiryInterval() == 0L, connectionConfig.getSessionExpiryInterval(), new MqttConnectRestrictions(connectionConfig.getReceiveMaximum(), connectionConfig.getSendMaximum(), connectionConfig.getMaximumPacketSize(), connectionConfig.getSendMaximumPacketSize(), connectionConfig.getTopicAliasMaximum(), connectionConfig.getSendTopicAliasMaximum(), connectionConfig.isProblemInformationRequested(), connectionConfig.isResponseInformationRequested()), connectDefaults.getSimpleAuth(), enhancedAuthMechanism == null ? connectDefaults.getEnhancedAuthMechanism() : enhancedAuthMechanism, connectDefaults.getWillPublish(), MqttUserPropertiesImpl.NO_USER_PROPERTIES);
        MqttConnAckSingle.reconnect(this.clientConfig, disconnectEvent.getSource(), disconnectEvent.getCause(), connect, eventLoop);
    }

    @Override
    public boolean isSharable() {
        return false;
    }

    private static class DisconnectingState
    implements Runnable {
        @NotNull
        private final Channel channel;
        private final @NotNull MqttDisconnectEvent.ByUser disconnectEvent;
        @NotNull
        private final ScheduledFuture<?> timeoutFuture;

        DisconnectingState(@NotNull Channel channel, @NotNull MqttDisconnectEvent.ByUser disconnectEvent) {
            this.channel = channel;
            this.disconnectEvent = disconnectEvent;
            this.timeoutFuture = channel.eventLoop().schedule((Runnable)this, 10L, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            this.channel.close();
        }
    }
}

