/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder.mqtt3;

import com.hivemq.client.internal.mqtt.codec.encoder.mqtt3.Mqtt3MessageEncoder;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttStatefulUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.mqtt.mqtt3.message.Mqtt3MessageType;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt3UnsubscribeEncoder
extends Mqtt3MessageEncoder<MqttStatefulUnsubscribe> {
    private static final int FIXED_HEADER = Mqtt3MessageType.UNSUBSCRIBE.getCode() << 4 | 2;
    private static final int VARIABLE_HEADER_FIXED_LENGTH = 2;

    @Inject
    Mqtt3UnsubscribeEncoder() {
    }

    @Override
    int remainingLength(@NotNull MqttStatefulUnsubscribe message) {
        int remainingLength = 2;
        List subscriptions = ((MqttUnsubscribe)message.stateless()).getTopicFilters();
        for (int i = 0; i < subscriptions.size(); ++i) {
            remainingLength += ((MqttTopicFilterImpl)subscriptions.get(i)).encodedLength();
        }
        return remainingLength;
    }

    @Override
    void encode(@NotNull MqttStatefulUnsubscribe message, @NotNull ByteBuf out, int remainingLength) {
        this.encodeFixedHeader(out, remainingLength);
        this.encodeVariableHeader(message, out);
        this.encodePayload(message, out);
    }

    private void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private void encodeVariableHeader(@NotNull MqttStatefulUnsubscribe message, @NotNull ByteBuf out) {
        out.writeShort(message.getPacketIdentifier());
    }

    private void encodePayload(@NotNull MqttStatefulUnsubscribe message, @NotNull ByteBuf out) {
        List subscriptions = ((MqttUnsubscribe)message.stateless()).getTopicFilters();
        for (int i = 0; i < subscriptions.size(); ++i) {
            ((MqttTopicFilterImpl)subscriptions.get(i)).encode(out);
        }
    }
}

