/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletionStage;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.util.function.Consumer;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Success;

@ProviderType
public interface Promise<T> {
    public boolean isDone();

    public T getValue() throws InvocationTargetException, InterruptedException;

    public Throwable getFailure() throws InterruptedException;

    public Promise<T> onResolve(Runnable var1);

    public Promise<T> onSuccess(Consumer<? super T> var1);

    public Promise<T> onFailure(Consumer<? super Throwable> var1);

    public <R> Promise<R> then(Success<? super T, ? extends R> var1, Failure var2);

    public <R> Promise<R> then(Success<? super T, ? extends R> var1);

    public Promise<T> thenAccept(Consumer<? super T> var1);

    public Promise<T> filter(Predicate<? super T> var1);

    public <R> Promise<R> map(Function<? super T, ? extends R> var1);

    public <R> Promise<R> flatMap(Function<? super T, Promise<? extends R>> var1);

    public Promise<T> recover(Function<Promise<?>, ? extends T> var1);

    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> var1);

    public Promise<T> fallbackTo(Promise<? extends T> var1);

    public Promise<T> timeout(long var1);

    public Promise<T> delay(long var1);

    public CompletionStage<T> toCompletionStage();

    public <F> Promise<T> onFailure(Consumer<? super F> var1, Class<? extends F> var2);

    public Promise<T> recover(Function<Promise<?>, ? extends T> var1, Class<?> var2);

    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> var1, Class<?> var2);

    public Promise<T> fallbackTo(Promise<? extends T> var1, Class<?> var2);
}

