/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.dir;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.ExportProviderFactory;
import org.keycloak.exportimport.UsersExportStrategy;
import org.keycloak.exportimport.dir.DirExportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class DirExportProviderFactory
implements ExportProviderFactory {
    public static final String PROVIDER_ID = "dir";
    public static final String DIR = "dir";
    public static final String REALM_NAME = "realmName";
    public static final String USERS_EXPORT_STRATEGY = "usersExportStrategy";
    public static final String USERS_PER_FILE = "usersPerFile";
    private Config.Scope config;

    public ExportProvider create(KeycloakSession session) {
        String dir = System.getProperty("keycloak.migration.dir", this.config.get("dir"));
        String realmName = System.getProperty("keycloak.migration.realmName", this.config.get(REALM_NAME));
        String usersExportStrategy = System.getProperty("keycloak.migration.usersExportStrategy", this.config.get(USERS_EXPORT_STRATEGY, ExportImportConfig.DEFAULT_USERS_EXPORT_STRATEGY.toString()));
        String usersPerFile = System.getProperty("keycloak.migration.usersPerFile", this.config.get(USERS_PER_FILE, String.valueOf(ExportImportConfig.DEFAULT_USERS_PER_FILE)));
        return ((DirExportProvider)((DirExportProvider)new DirExportProvider(session.getKeycloakSessionFactory()).withDir(dir).withRealmName(realmName)).withUsersExportStrategy(Enum.valueOf(UsersExportStrategy.class, usersExportStrategy.toUpperCase()))).withUsersPerFile(Integer.parseInt(usersPerFile.trim()));
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "dir";
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(REALM_NAME).type("string").helpText("Realm to export").add().property().name("dir").type("string").helpText("Directory to export to").add().property().name(USERS_EXPORT_STRATEGY).type("string").helpText("Users export strategy").defaultValue((Object)ExportImportConfig.DEFAULT_USERS_EXPORT_STRATEGY).add().property().name(USERS_PER_FILE).type("int").helpText("Users per exported file").defaultValue((Object)ExportImportConfig.DEFAULT_USERS_PER_FILE).add().build();
    }
}

