/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.regex.Pattern;
import nu.validator.htmlparser.sax.XmlSerializer;
import nu.validator.io.SystemIdIOException;
import nu.validator.json.Serializer;
import nu.validator.messages.GnuMessageEmitter;
import nu.validator.messages.JsonMessageEmitter;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.messages.TextMessageEmitter;
import nu.validator.messages.XmlMessageEmitter;
import nu.validator.servlet.imagereview.ImageCollector;
import nu.validator.source.SourceCode;
import nu.validator.validation.SimpleDocumentValidator;
import nu.validator.xml.SystemErrErrorHandler;
import org.apache.http.ConnectionClosedException;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.TruncatedChunkException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleCommandLineValidator {
    private static String userAgent;
    private static SimpleDocumentValidator validator;
    private static OutputStream out;
    private static PrintStream otherOut;
    private static Pattern filterPattern;
    private static MessageEmitterAdapter errorHandler;
    private static boolean verbose;
    private static boolean errorsOnly;
    private static boolean wError;
    private static boolean exitZeroAlways;
    private static boolean loadEntities;
    private static boolean noLangDetect;
    private static boolean noStream;
    private static boolean alsoCheckCSS;
    private static boolean skipNonCSS;
    private static boolean forceCSS;
    private static boolean alsoCheckSVG;
    private static boolean skipNonSVG;
    private static boolean forceSVG;
    private static boolean skipNonHTML;
    private static boolean forceHTML;
    private static boolean forceXML;
    private static boolean asciiQuotes;
    private static int lineOffset;
    private static OutputFormat outputFormat;
    private static String schemaUrl;
    private static boolean hasSchemaOption;
    private static Properties props;

    public static void main(String[] args) throws SAXException, Exception {
        out = System.err;
        otherOut = System.out;
        userAgent = "Validator.nu/LV";
        System.setProperty("nu.validator.datatype.warn", "true");
        errorsOnly = false;
        wError = false;
        alsoCheckCSS = false;
        skipNonCSS = false;
        forceCSS = false;
        alsoCheckSVG = false;
        skipNonSVG = false;
        forceSVG = false;
        skipNonHTML = false;
        forceHTML = false;
        forceXML = false;
        loadEntities = false;
        exitZeroAlways = false;
        noLangDetect = false;
        noStream = false;
        lineOffset = 0;
        asciiQuotes = false;
        verbose = false;
        filterPattern = null;
        String filterString = "";
        String outFormat = null;
        schemaUrl = null;
        hasSchemaOption = false;
        boolean hasFileArgs = false;
        boolean readFromStdIn = false;
        int fileArgsStart = 0;
        if (args.length == 0) {
            SimpleCommandLineValidator.usage();
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-")) {
                readFromStdIn = true;
                break;
            }
            if (!args[i].startsWith("--")) {
                hasFileArgs = true;
                fileArgsStart = i;
                break;
            }
            if ("--asciiquotes".equals(args[i])) {
                asciiQuotes = true;
                continue;
            }
            if ("--errors-only".equals(args[i])) {
                errorsOnly = true;
                System.setProperty("nu.validator.datatype.warn", "false");
                continue;
            }
            if ("--Werror".equals(args[i])) {
                wError = true;
                continue;
            }
            if ("--exit-zero-always".equals(args[i])) {
                exitZeroAlways = true;
                continue;
            }
            if ("--stdout".equals(args[i])) {
                out = System.out;
                otherOut = System.err;
                continue;
            }
            if ("--filterfile".equals(args[i])) {
                File filterFile = new File(args[++i]);
                StringBuilder sb = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filterFile), "UTF-8"));){
                    String line;
                    String pipe = "";
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        sb.append(pipe);
                        sb.append(line);
                        pipe = "|";
                    }
                    if (sb.length() == 0) continue;
                    if ("".equals(filterString)) {
                        filterString = sb.toString();
                        continue;
                    }
                    filterString = filterString + "|" + sb.toString();
                }
                catch (FileNotFoundException e) {
                    System.err.println("error: File not found: " + filterFile.getPath());
                    System.exit(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("--filterpattern".equals(args[i])) {
                if ("".equals(filterString)) {
                    filterString = args[++i];
                    continue;
                }
                filterString = filterString + "|" + args[++i];
                continue;
            }
            if ("--format".equals(args[i])) {
                outFormat = args[++i];
                continue;
            }
            if ("--help".equals(args[i])) {
                SimpleCommandLineValidator.help();
                System.exit(0);
                continue;
            }
            if ("--skip-non-css".equals(args[i])) {
                skipNonCSS = true;
                continue;
            }
            if ("--css".equals(args[i])) {
                forceCSS = true;
                continue;
            }
            if ("--skip-non-svg".equals(args[i])) {
                skipNonSVG = true;
                continue;
            }
            if ("--svg".equals(args[i])) {
                forceSVG = true;
                continue;
            }
            if ("--skip-non-html".equals(args[i])) {
                skipNonHTML = true;
                continue;
            }
            if ("--html".equals(args[i])) {
                forceHTML = true;
                continue;
            }
            if ("--xml".equals(args[i])) {
                forceXML = true;
                continue;
            }
            if ("--also-check-css".equals(args[i])) {
                alsoCheckCSS = true;
                continue;
            }
            if ("--also-check-svg".equals(args[i])) {
                alsoCheckSVG = true;
                continue;
            }
            if ("--user-agent".equals(args[i])) {
                userAgent = args[++i];
                continue;
            }
            if ("--no-langdetect".equals(args[i])) {
                noLangDetect = true;
                continue;
            }
            if ("--no-stream".equals(args[i])) {
                noStream = true;
                continue;
            }
            if ("--verbose".equals(args[i])) {
                verbose = true;
                continue;
            }
            if ("--version".equals(args[i])) {
                SimpleCommandLineValidator.version();
                System.exit(0);
                continue;
            }
            if ("--entities".equals(args[i])) {
                loadEntities = true;
                continue;
            }
            if (!"--schema".equals(args[i])) continue;
            hasSchemaOption = true;
            if ((schemaUrl = args[++i]).startsWith("http:") || schemaUrl.startsWith("https:")) continue;
            System.err.println("error: The \"--schema\" option requires a URL for a schema.");
            System.exit(1);
        }
        if (!"".equals(filterString)) {
            filterPattern = Pattern.compile(filterString);
        }
        if (schemaUrl == null) {
            schemaUrl = "http://s.validator.nu/html5-all.rnc";
        }
        if (outFormat == null) {
            outputFormat = OutputFormat.GNU;
        } else if ("text".equals(outFormat)) {
            outputFormat = OutputFormat.TEXT;
        } else if ("gnu".equals(outFormat)) {
            outputFormat = OutputFormat.GNU;
        } else if ("xml".equals(outFormat)) {
            outputFormat = OutputFormat.XML;
        } else if ("json".equals(outFormat)) {
            outputFormat = OutputFormat.JSON;
        } else {
            System.err.printf("Error: Unsupported output format \"%s\". Must be \"gnu\", \"xml\", \"json\", or \"text\".\n", outFormat);
            System.exit(1);
        }
        if (readFromStdIn) {
            InputSource is = new InputSource(System.in);
            validator = noLangDetect ? new SimpleDocumentValidator(true, false, false) : new SimpleDocumentValidator();
            SimpleCommandLineValidator.setup(schemaUrl);
            if (forceCSS) {
                validator.checkCssInputSource(is);
            } else if (forceSVG) {
                SimpleCommandLineValidator.checkSvgInputSource(is);
            } else {
                validator.checkHtmlInputSource(is);
            }
            SimpleCommandLineValidator.end();
        } else if (hasFileArgs) {
            validator = noLangDetect ? new SimpleDocumentValidator(true, false, false) : new SimpleDocumentValidator(true, false, true);
            SimpleCommandLineValidator.setup(schemaUrl);
            SimpleCommandLineValidator.checkFiles(args, fileArgsStart);
            SimpleCommandLineValidator.end();
        } else {
            System.err.printf("\nError: No documents specified.\n", new Object[0]);
            SimpleCommandLineValidator.usage();
            System.exit(1);
        }
    }

    private static void setSchema(String schemaUrl) throws SAXException, Exception {
        try {
            validator.setUpMainSchema(schemaUrl, new SystemErrErrorHandler());
        }
        catch (SimpleDocumentValidator.SchemaReadException e) {
            otherOut.println(e.getMessage() + " Terminating.");
            System.exit(1);
        }
        catch (StackOverflowError e) {
            otherOut.println("StackOverflowError while evaluating HTML schema.");
            otherOut.println("The checker requires a java thread stack size of at least 512k.");
            otherOut.println("Consider invoking java with the -Xss option. For example:");
            otherOut.println("\n  java -Xss512k -jar ~/vnu.jar FILE.html");
            System.exit(1);
        }
        validator.setUpValidatorAndParsers(errorHandler, noStream, loadEntities);
    }

    private static void setup(String schemaUrl) throws SAXException, Exception {
        SimpleCommandLineValidator.setErrorHandler();
        if (SimpleCommandLineValidator.cssCheckingEnabled()) {
            errorHandler.setLineOffset(-1);
        }
        errorHandler.setHtml(true);
        errorHandler.start(null);
        validator.setAllowCss(SimpleCommandLineValidator.cssCheckingEnabled());
        SimpleCommandLineValidator.setSchema(schemaUrl);
    }

    private static void end() throws SAXException {
        errorHandler.end("Document checking completed. No errors found.", "Document checking completed.", "");
        if (errorHandler.getErrors() > 0 || errorHandler.getFatalErrors() > 0 || wError && errorHandler.getWarnings() > 0 && !errorsOnly) {
            System.exit(exitZeroAlways ? 0 : 1);
        }
    }

    private static void checkFiles(String[] args, int fileArgsStart) throws IOException, Exception, SAXException {
        for (int i = fileArgsStart; i < args.length; ++i) {
            if (args[i].startsWith("http://") || args[i].startsWith("https://")) {
                SimpleCommandLineValidator.emitFilename(args[i]);
                try {
                    validator.checkHttpURL(args[i], userAgent, errorHandler);
                }
                catch (IOException e) {
                    if (e.getCause() instanceof TruncatedChunkException || e.getCause() instanceof MalformedChunkCodingException && e.getMessage().contains("CRLF expected at end of chunk") || e.getCause() instanceof ConnectionClosedException && e.getMessage().contains("closing chunk expected")) continue;
                    errorHandler.fatalError(new SAXParseException(e.getMessage(), null, args[i], -1, -1, new SystemIdIOException(args[i], e.getMessage())));
                }
                continue;
            }
            File file = new File(args[i]);
            if (file.isDirectory()) {
                SimpleCommandLineValidator.recurseDirectory(file);
                continue;
            }
            if (forceCSS) {
                SimpleCommandLineValidator.checkCssFile(file);
                continue;
            }
            if (skipNonCSS) {
                if (!SimpleCommandLineValidator.isCss(file)) continue;
                SimpleCommandLineValidator.checkCssFile(file);
                continue;
            }
            if (alsoCheckCSS && SimpleCommandLineValidator.isCss(file)) {
                SimpleCommandLineValidator.checkCssFile(file);
                continue;
            }
            if (forceSVG) {
                SimpleCommandLineValidator.checkSvgFile(file);
                continue;
            }
            if (skipNonSVG) {
                if (!SimpleCommandLineValidator.isSvg(file)) continue;
                SimpleCommandLineValidator.checkSvgFile(file);
                continue;
            }
            if (alsoCheckSVG && SimpleCommandLineValidator.isSvg(file)) {
                SimpleCommandLineValidator.checkSvgFile(file);
                continue;
            }
            SimpleCommandLineValidator.checkHtmlFile(file);
        }
    }

    private static void recurseDirectory(File directory) throws IOException, Exception {
        if (directory.canRead()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    SimpleCommandLineValidator.recurseDirectory(file);
                    continue;
                }
                if (forceCSS) {
                    SimpleCommandLineValidator.checkCssFile(file);
                    continue;
                }
                if (skipNonCSS) {
                    if (!SimpleCommandLineValidator.isCss(file)) continue;
                    SimpleCommandLineValidator.checkCssFile(file);
                    continue;
                }
                if (alsoCheckCSS && SimpleCommandLineValidator.isCss(file)) {
                    SimpleCommandLineValidator.checkCssFile(file);
                    continue;
                }
                if (forceSVG) {
                    SimpleCommandLineValidator.checkSvgFile(file);
                    continue;
                }
                if (skipNonSVG) {
                    if (!SimpleCommandLineValidator.isSvg(file)) continue;
                    SimpleCommandLineValidator.checkSvgFile(file);
                    continue;
                }
                if (alsoCheckSVG && SimpleCommandLineValidator.isSvg(file)) {
                    SimpleCommandLineValidator.checkSvgFile(file);
                    continue;
                }
                SimpleCommandLineValidator.checkHtmlFile(file);
            }
        }
    }

    private static void checkSvgInputSource(InputSource is) throws Exception {
        if (!"http://s.validator.nu/svg-xhtml5-rdf-mathml.rnc".equals(validator.getMainSchemaUrl()) && !hasSchemaOption) {
            SimpleCommandLineValidator.setSchema("http://s.validator.nu/svg-xhtml5-rdf-mathml.rnc");
        }
        validator.checkXmlInputSource(is);
    }

    private static void checkSvgFile(File file) throws IOException, Exception {
        block5: {
            if (!"http://s.validator.nu/svg-xhtml5-rdf-mathml.rnc".equals(validator.getMainSchemaUrl()) && !hasSchemaOption) {
                SimpleCommandLineValidator.setSchema("http://s.validator.nu/svg-xhtml5-rdf-mathml.rnc");
            }
            try {
                String path = file.getPath();
                if (!file.exists()) {
                    if (verbose) {
                        errorHandler.warning(new SAXParseException("File not found.", null, file.toURI().toURL().toString(), -1, -1));
                    }
                    return;
                }
                SimpleCommandLineValidator.emitFilename(path);
                validator.checkXmlFile(file);
            }
            catch (SAXException e) {
                if (errorsOnly) break block5;
                System.err.printf("\"%s\":-1:-1: warning: %s\n", file.toURI().toURL().toString(), e.getMessage());
            }
        }
    }

    private static void checkCssFile(File file) throws IOException, Exception {
        block5: {
            if (!"http://s.validator.nu/xhtml5-all.rnc".equals(validator.getMainSchemaUrl()) && !hasSchemaOption) {
                SimpleCommandLineValidator.setSchema("http://s.validator.nu/xhtml5-all.rnc");
            }
            try {
                String path = file.getPath();
                if (!file.exists()) {
                    if (verbose) {
                        errorHandler.warning(new SAXParseException("File not found.", null, file.toURI().toURL().toString(), -1, -1));
                    }
                    return;
                }
                SimpleCommandLineValidator.emitFilename(path);
                validator.checkCssFile(file, true);
            }
            catch (SAXException e) {
                if (errorsOnly) break block5;
                System.err.printf("\"%s\":-1:-1: warning: %s\n", file.toURI().toURL().toString(), e.getMessage());
            }
        }
    }

    private static void checkHtmlFile(File file) throws IOException, Exception {
        block16: {
            try {
                String path = file.getPath();
                if (!file.exists()) {
                    if (verbose) {
                        errorHandler.warning(new SAXParseException("File not found.", null, file.toURI().toURL().toString(), -1, -1));
                    }
                    return;
                }
                if (SimpleCommandLineValidator.isXhtml(file)) {
                    SimpleCommandLineValidator.emitFilename(path);
                    if (forceHTML) {
                        validator.checkHtmlFile(file, true);
                    } else {
                        if (!"http://s.validator.nu/xhtml5-all.rnc".equals(validator.getMainSchemaUrl()) && !hasSchemaOption) {
                            SimpleCommandLineValidator.setSchema("http://s.validator.nu/xhtml5-all.rnc");
                        }
                        validator.checkXmlFile(file);
                    }
                } else if (SimpleCommandLineValidator.isHtml(file)) {
                    SimpleCommandLineValidator.emitFilename(path);
                    if (forceXML) {
                        if (!"http://s.validator.nu/xhtml5-all.rnc".equals(validator.getMainSchemaUrl()) && !hasSchemaOption) {
                            SimpleCommandLineValidator.setSchema("http://s.validator.nu/xhtml5-all.rnc");
                        }
                        validator.checkXmlFile(file);
                    } else {
                        if (!"http://s.validator.nu/html5-all.rnc".equals(validator.getMainSchemaUrl()) && !hasSchemaOption) {
                            SimpleCommandLineValidator.setSchema("http://s.validator.nu/html5-all.rnc");
                        }
                        validator.checkHtmlFile(file, true);
                    }
                } else if (verbose) {
                    errorHandler.warning(new SAXParseException("File was not checked. Files must have .html, .xhtml, .htm, or .xht extensions.", null, file.toURI().toURL().toString(), -1, -1));
                }
            }
            catch (SAXException e) {
                if (errorsOnly) break block16;
                System.err.printf("\"%s\":-1:-1: warning: %s\n", file.toURI().toURL().toString(), e.getMessage());
            }
        }
    }

    private static boolean cssCheckingEnabled() {
        return forceCSS || alsoCheckCSS;
    }

    private static boolean isCss(File file) {
        String name = file.getName();
        return name.endsWith(".css");
    }

    private static boolean isSvg(File file) {
        String name = file.getName();
        return name.endsWith(".svg");
    }

    private static boolean isXhtml(File file) {
        String name = file.getName();
        return name.endsWith(".xhtml") || name.endsWith(".xht");
    }

    private static boolean isHtml(File file) {
        String name = file.getName();
        return name.endsWith(".html") || name.endsWith(".htm") || !skipNonHTML;
    }

    private static void emitFilename(String name) {
        if (verbose) {
            otherOut.println(name);
        }
    }

    private static void setErrorHandler() {
        SourceCode sourceCode = validator.getSourceCode();
        ImageCollector imageCollector = new ImageCollector(sourceCode);
        boolean showSource = false;
        if (outputFormat == OutputFormat.TEXT) {
            errorHandler = new MessageEmitterAdapter(filterPattern, sourceCode, showSource, imageCollector, lineOffset, true, new TextMessageEmitter(out, asciiQuotes));
        } else if (outputFormat == OutputFormat.GNU) {
            errorHandler = new MessageEmitterAdapter(filterPattern, sourceCode, showSource, imageCollector, lineOffset, true, new GnuMessageEmitter(out, asciiQuotes));
        } else if (outputFormat == OutputFormat.XML) {
            errorHandler = new MessageEmitterAdapter(filterPattern, sourceCode, showSource, imageCollector, lineOffset, true, new XmlMessageEmitter(new XmlSerializer(out)));
        } else if (outputFormat == OutputFormat.JSON) {
            String callback = null;
            errorHandler = new MessageEmitterAdapter(filterPattern, sourceCode, showSource, imageCollector, lineOffset, true, new JsonMessageEmitter(new Serializer(out), callback, asciiQuotes, props.getProperty("nu.validator.servlet.version", "[unknown version]")));
        } else {
            throw new RuntimeException("Bug. Should be unreachable.");
        }
        errorHandler.setErrorsOnly(errorsOnly);
    }

    private static void usage() {
        try (InputStream help = SimpleCommandLineValidator.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/usage");){
            otherOut.println("");
            int b = help.read();
            while (b != -1) {
                otherOut.write(b);
                b = help.read();
            }
            otherOut.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void help() {
        try (InputStream help = SimpleCommandLineValidator.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/cli-help");){
            otherOut.println("");
            int b = help.read();
            while (b != -1) {
                otherOut.write(b);
                b = help.read();
            }
            otherOut.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void version() {
        otherOut.println(props.getProperty("nu.validator.servlet.version", "[unknown version]"));
        otherOut.flush();
    }

    static {
        props = new Properties();
        try {
            props.load(SimpleDocumentValidator.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/misc.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static enum OutputFormat {
        HTML,
        XHTML,
        TEXT,
        XML,
        JSON,
        RELAXED,
        SOAP,
        UNICORN,
        GNU;

    }
}

