# Greek (Dante)

## Introduction

Dante Alighieri mentions several stars and a few constellations: predominantly, the zodiacal constellation of Gemini. The Twins occurs in his texts (in the comedia as well as his poems). As Dante is not an astronomer but a person with broad knowledge, his view of the constellations is highly like not based upon observations of the sky but on manuscripts that he read. Therefore, we chose to take the zodiacal constellation images from Michael Scotus whose manuscript was very popular in Dante's time.

Dante Alighieri was a citizen of Florence, Italy, who was later banned and lived at several places in Northern Italy. The comedia was written around 1300 but finished only short before his death in 1321. It is commonly assumed that the story plays in around the Christian festival of Easter in 1300 CE.

## Description

### How this Sky Culture was made

The Dante experts of the German Dante Society selected some text passages with astronomical references in order to present them at Planetarium Jena in the dome. Professor Blume's suggestion that Dante likely had Michael Scotus's drawings of the constellations in mind was accepted. Therefore, we copied these drawings and mapped them onto the stars. The "16" bright stars that are mentioned by Dante are usually interpreted by romanists as the stars of first magnitude in the Almagest. Therefore, these stars where highlighted with the "star"-symbol in Stellarium. Additionally, we painted a chariot (wagon) and a horn.

Dante calls the seven bright stars of Ursa Major "The Chariot", the constellation of Ursa Minor "The Horn", and possibly refers to Corona Borealis when he mentions a ring of stars. The latter interpretation is in our view unlikely but is discussed among researchers which is why we marked the stars of Corona Borealis as it is described in the Almagest.

## References

The Italian Dante Society (Societá Dantesca Italiana) provides Dante's work online: [Dante_Online](https://danteonline.it/opere/index.php).

### Fair Use

We provide this sky culture free of charge, but the authors deserve to be cited according to the usual rules. Thank you!

Susanne M Hoffmann, Dieter Blume, Karl Ph. Ellerbrock, Eduardo Castadura, Bodo Zöll (2022)

## Authors

This sky culture was added to Stellarium by Susanne M. Hoffmann (service@uhura-uraniae.com) as a byproduct of a collaboration with Prof. Dr. Dieter Blume (Art History, FSU Jena, Germany), The German Dante Society (Deutsche Dante Gesellschaft) and Planetarium Jena.

Written in English: Susanne M. Hoffmann.

### Notes

Region of origin: Florence, Italy; this single sky culture was made for use in research.

## License

CC BY-ND 4.0
