/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.InputStream;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;

public final class MetalworksFrame
extends JFrame {
    JMenuBar menuBar;
    JDesktopPane desktop;
    JInternalFrame toolPalette;
    JCheckBoxMenuItem showToolPaletteMenuItem;
    static final Integer DOCLAYER = 5;
    static final Integer TOOLLAYER = 6;
    static final Integer HELPLAYER = 7;
    static final String ABOUTMSG = "Metalworks \n \nAn application written to show off the Java Look & Feel. \n \nWritten by the JavaSoft Look & Feel Team \n  Michael Albers\n  Tom Santos\n  Jeff Shapiro\n  Steve Wilson";

    public MetalworksFrame() {
        super("Metalworks");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(50, 50, dimension.width - 100, dimension.height - 100);
        this.buildContent();
        this.buildMenus();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MetalworksFrame.this.quit();
            }
        });
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    protected void buildMenus() {
        MetalTheme[] metalThemeArray;
        this.menuBar = new JMenuBar();
        this.menuBar.setOpaque(true);
        JMenu jMenu = this.buildFileMenu();
        JMenu jMenu2 = this.buildEditMenu();
        JMenu jMenu3 = this.buildViewsMenu();
        JMenu jMenu4 = this.buildSpeedMenu();
        JMenu jMenu5 = this.buildHelpMenu();
        PropertiesMetalTheme propertiesMetalTheme = null;
        try {
            metalThemeArray = this.getClass().getResourceAsStream("/resources/MyTheme.theme");
            propertiesMetalTheme = new PropertiesMetalTheme((InputStream)metalThemeArray);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println(nullPointerException);
        }
        metalThemeArray = new MetalTheme[]{new OceanTheme(), new DefaultMetalTheme(), new GreenMetalTheme(), new AquaMetalTheme(), new KhakiMetalTheme(), new DemoMetalTheme(), new ContrastMetalTheme(), new BigContrastMetalTheme(), propertiesMetalTheme};
        MetalThemeMenu metalThemeMenu = new MetalThemeMenu("Theme", metalThemeArray);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.menuBar.add(metalThemeMenu);
        this.menuBar.add(jMenu4);
        this.menuBar.add(jMenu5);
        this.setJMenuBar(this.menuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("New");
        JMenuItem jMenuItem2 = new JMenuItem("Open");
        JMenuItem jMenuItem3 = new JMenuItem("Quit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.newDocument();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.openDocument();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.quit();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    protected JMenu buildEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        JMenuItem jMenuItem = new JMenuItem("Undo");
        JMenuItem jMenuItem2 = new JMenuItem("Copy");
        JMenuItem jMenuItem3 = new JMenuItem("Cut");
        JMenuItem jMenuItem4 = new JMenuItem("Paste");
        JMenuItem jMenuItem5 = new JMenuItem("Preferences...");
        jMenuItem.setEnabled(false);
        jMenuItem2.setEnabled(false);
        jMenuItem3.setEnabled(false);
        jMenuItem4.setEnabled(false);
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.openPrefsWindow();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        return jMenu;
    }

    protected JMenu buildViewsMenu() {
        JMenu jMenu = new JMenu("Views");
        JMenuItem jMenuItem = new JMenuItem("Open In-Box");
        JMenuItem jMenuItem2 = new JMenuItem("Open Out-Box");
        jMenuItem2.setEnabled(false);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.openInBox();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    protected JMenu buildSpeedMenu() {
        JMenu jMenu = new JMenu("Drag");
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Live");
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Outline");
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Old and Slow");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        jRadioButtonMenuItem.setSelected(true);
        jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.desktop.setDragMode(-1);
            }
        });
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.desktop.setDragMode(0);
            }
        });
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.desktop.setDragMode(1);
            }
        });
        jMenu.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem2);
        jMenu.add(jRadioButtonMenuItem3);
        return jMenu;
    }

    protected JMenu buildHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("About Metalworks...");
        JMenuItem jMenuItem2 = new JMenuItem("Open Help Window");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.showAboutBox();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetalworksFrame.this.openHelpWindow();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    protected void buildContent() {
        this.desktop = new JDesktopPane();
        this.getContentPane().add(this.desktop);
    }

    public void quit() {
        System.exit(0);
    }

    public void newDocument() {
        MetalworksDocumentFrame metalworksDocumentFrame = new MetalworksDocumentFrame();
        this.desktop.add((Component)metalworksDocumentFrame, DOCLAYER);
        try {
            metalworksDocumentFrame.setVisible(true);
            metalworksDocumentFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void openDocument() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.showOpenDialog(this);
    }

    public void openHelpWindow() {
        MetalworksHelp metalworksHelp = new MetalworksHelp();
        this.desktop.add((Component)metalworksHelp, HELPLAYER);
        try {
            metalworksHelp.setVisible(true);
            metalworksHelp.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void showAboutBox() {
        JOptionPane.showMessageDialog(this, ABOUTMSG);
    }

    public void openPrefsWindow() {
        MetalworksPrefs metalworksPrefs = new MetalworksPrefs(this);
        metalworksPrefs.setVisible(true);
    }

    public void openInBox() {
        MetalworksInBox metalworksInBox = new MetalworksInBox();
        this.desktop.add((Component)metalworksInBox, DOCLAYER);
        try {
            metalworksInBox.setVisible(true);
            metalworksInBox.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }
}

