/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public class Shell
extends ScriptableObject {
    private static final long serialVersionUID = -5638074146250193112L;
    private boolean quitting;

    public String getClassName() {
        return "global";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Context context = Context.enter();
        try {
            Object[] objectArray;
            Shell shell = new Shell();
            context.initStandardObjects((ScriptableObject)shell);
            String[] stringArray2 = new String[]{"print", "quit", "version", "load", "help"};
            shell.defineFunctionProperties(stringArray2, Shell.class, 2);
            stringArray = Shell.processOptions(context, stringArray);
            if (stringArray.length == 0) {
                objectArray = new Object[]{};
            } else {
                int n = stringArray.length - 1;
                objectArray = new Object[n];
                System.arraycopy(stringArray, 1, objectArray, 0, n);
            }
            Scriptable scriptable = context.newArray((Scriptable)shell, objectArray);
            shell.defineProperty("arguments", scriptable, 2);
            shell.processSource(context, stringArray.length == 0 ? null : stringArray[0]);
        }
        finally {
            Context.exit();
        }
    }

    public static String[] processOptions(Context context, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("-")) {
                String[] stringArray2 = new String[stringArray.length - i];
                for (int j = i; j < stringArray.length; ++j) {
                    stringArray2[j - i] = stringArray[j];
                }
                return stringArray2;
            }
            if (string.equals("-version")) {
                double d;
                if (++i == stringArray.length) {
                    Shell.usage(string);
                }
                if ((d = Context.toNumber((Object)stringArray[i])) != d) {
                    Shell.usage(string);
                }
                context.setLanguageVersion((int)d);
                continue;
            }
            Shell.usage(string);
        }
        return new String[0];
    }

    private static void usage(String string) {
        Shell.p("Didn't understand \"" + string + "\".");
        Shell.p("Valid arguments are:");
        Shell.p("-version 100|110|120|130|140|150|160|170");
        System.exit(1);
    }

    public void help() {
        Shell.p("");
        Shell.p("Command                Description");
        Shell.p("=======                ===========");
        Shell.p("help()                 Display usage and help messages. ");
        Shell.p("defineClass(className) Define an extension using the Java class");
        Shell.p("                       named with the string argument. ");
        Shell.p("                       Uses ScriptableObject.defineClass(). ");
        Shell.p("load(['foo.js', ...])  Load JavaScript source files named by ");
        Shell.p("                       string arguments. ");
        Shell.p("loadClass(className)   Load a class named by a string argument.");
        Shell.p("                       The class must be a script compiled to a");
        Shell.p("                       class file. ");
        Shell.p("print([expr ...])      Evaluate and print expressions. ");
        Shell.p("quit()                 Quit the shell. ");
        Shell.p("version([number])      Get or set the JavaScript version number.");
        Shell.p("");
    }

    public static void print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                System.out.print(" ");
            }
            String string = Context.toString((Object)objectArray[i]);
            System.out.print(string);
        }
        System.out.println();
    }

    public void quit() {
        this.quitting = true;
    }

    public static double version(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = context.getLanguageVersion();
        if (objectArray.length > 0) {
            double d2 = Context.toNumber((Object)objectArray[0]);
            context.setLanguageVersion((int)d2);
        }
        return d;
    }

    public static void load(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Shell shell = (Shell)Shell.getTopLevelScope((Scriptable)scriptable);
        for (int i = 0; i < objectArray.length; ++i) {
            shell.processSource(context, Context.toString((Object)objectArray[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSource(Context context, String string) {
        if (string == null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string2 = "<stdin>";
            int n = 1;
            boolean bl = false;
            do {
                int n2 = n;
                System.err.print("js> ");
                System.err.flush();
                try {
                    Object object;
                    String string3 = "";
                    do {
                        if ((object = bufferedReader.readLine()) == null) {
                            bl = true;
                            break;
                        }
                        string3 = string3 + (String)object + "\n";
                        ++n;
                    } while (!context.stringIsCompilableUnit(string3));
                    object = context.evaluateString((Scriptable)this, string3, string2, n2, null);
                    if (object == Context.getUndefinedValue()) continue;
                    System.err.println(Context.toString((Object)object));
                }
                catch (WrappedException wrappedException) {
                    System.err.println(wrappedException.getWrappedException().toString());
                    wrappedException.printStackTrace();
                }
                catch (EvaluatorException evaluatorException) {
                    System.err.println("js: " + evaluatorException.getMessage());
                }
                catch (JavaScriptException javaScriptException) {
                    System.err.println("js: " + javaScriptException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                }
            } while (!this.quitting && !bl);
            System.err.println();
        } else {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Context.reportError((String)("Couldn't open file \"" + string + "\"."));
                return;
            }
            try {
                context.evaluateReader((Scriptable)this, (Reader)fileReader, string, 1, null);
            }
            catch (WrappedException wrappedException) {
                System.err.println(wrappedException.getWrappedException().toString());
                wrappedException.printStackTrace();
            }
            catch (EvaluatorException evaluatorException) {
                System.err.println("js: " + evaluatorException.getMessage());
            }
            catch (JavaScriptException javaScriptException) {
                System.err.println("js: " + javaScriptException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
            }
            finally {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                }
            }
        }
    }

    private static void p(String string) {
        System.out.println(string);
    }
}

