/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.assertion;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.BaseIDAbstractType;
import org.keycloak.dom.saml.v2.assertion.EncryptedElementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.AbstractStaxSamlAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLSubjectConfirmationParser;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.w3c.dom.Element;

public class SAMLSubjectParser
extends AbstractStaxSamlAssertionParser<SubjectType>
implements StaxParser {
    private static final SAMLSubjectParser INSTANCE = new SAMLSubjectParser();

    private SAMLSubjectParser() {
        super(SAMLAssertionQNames.SUBJECT);
    }

    public static SAMLSubjectParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected SubjectType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        return new SubjectType();
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, SubjectType target, SAMLAssertionQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case NAMEID: {
                NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                SubjectType.STSubType subType = new SubjectType.STSubType();
                subType.addBaseID((BaseIDAbstractType)nameID);
                target.setSubType(subType);
                break;
            }
            case ENCRYPTED_ID: {
                Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                SubjectType.STSubType subType = new SubjectType.STSubType();
                subType.setEncryptedID(new EncryptedElementType(domElement));
                target.setSubType(subType);
                break;
            }
            case SUBJECT_CONFIRMATION: {
                target.addConfirmation((SubjectConfirmationType)SAMLSubjectConfirmationParser.INSTANCE.parse(xmlEventReader));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

