/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerInternal;

public abstract class AuthenticationHandlerImpl<T extends AuthenticationProvider>
implements AuthenticationHandlerInternal {
    static final HttpException UNAUTHORIZED = new HttpException(401);
    static final HttpException BAD_REQUEST = new HttpException(400);
    static final HttpException BAD_METHOD = new HttpException(405);
    protected final T authProvider;
    protected final String mfa;

    public AuthenticationHandlerImpl(T authProvider) {
        this(authProvider, null);
    }

    public AuthenticationHandlerImpl(T authProvider, String mfa) {
        this.authProvider = authProvider;
        this.mfa = mfa;
    }

    public void handle(RoutingContext ctx) {
        User user;
        if (this.handlePreflight(ctx)) {
            return;
        }
        if (!ctx.request().isEnded()) {
            ctx.request().pause();
        }
        if ((user = ctx.user()) != null) {
            if (this.mfa != null) {
                if (this.mfa.equals(user.get("mfa"))) {
                    if (!ctx.request().isEnded()) {
                        ctx.request().resume();
                    }
                    this.postAuthentication(ctx);
                    return;
                }
            } else {
                if (!ctx.request().isEnded()) {
                    ctx.request().resume();
                }
                this.postAuthentication(ctx);
                return;
            }
        }
        this.authenticate(ctx, (Handler<AsyncResult<User>>)((Handler)authN -> {
            if (authN.succeeded()) {
                User authenticated = (User)authN.result();
                ctx.setUser(authenticated);
                Session session = ctx.session();
                if (session != null) {
                    session.regenerateId();
                }
                if (!ctx.request().isEnded()) {
                    ctx.request().resume();
                }
                this.postAuthentication(ctx);
            } else {
                Throwable cause = authN.cause();
                if (!ctx.request().isEnded()) {
                    ctx.request().resume();
                }
                this.processException(ctx, cause);
            }
        }));
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (exception != null && exception instanceof HttpException) {
            int statusCode = ((HttpException)exception).getStatusCode();
            String payload = ((HttpException)exception).getPayload();
            switch (statusCode) {
                case 302: {
                    ctx.response().putHeader(HttpHeaders.LOCATION, (CharSequence)payload).setStatusCode(302).end("Redirecting to " + payload + ".");
                    return;
                }
                case 401: {
                    if (!"XMLHttpRequest".equals(ctx.request().getHeader("X-Requested-With"))) {
                        this.setAuthenticateHeader(ctx);
                    }
                    ctx.fail(401, exception);
                    return;
                }
            }
            ctx.fail(statusCode, exception);
            return;
        }
        ctx.fail(exception);
    }

    private boolean handlePreflight(RoutingContext ctx) {
        String accessControlRequestHeader;
        HttpServerRequest request = ctx.request();
        if (request.method() == HttpMethod.OPTIONS && (accessControlRequestHeader = ctx.request().getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            for (String ctrlReq : accessControlRequestHeader.split(",")) {
                if (!ctrlReq.equalsIgnoreCase("Authorization")) continue;
                ctx.next();
                return true;
            }
        }
        return false;
    }
}

