/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLDocumentScanner;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyCharArray;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLMessageProvider;
import org.apache.xerces.utils.XMLMessages;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.GrammarResolverImpl;
import org.apache.xerces.validators.common.XMLValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public abstract class XMLParser
implements XMLErrorReporter,
XMLDocumentHandler.DTDHandler {
    protected static final String SAX2_FEATURES_PREFIX = "http://xml.org/sax/features/";
    protected static final String SAX2_PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    protected static final String XERCES_FEATURES_PREFIX = "http://apache.org/xml/features/";
    protected static final String XERCES_PROPERTIES_PREFIX = "http://apache.org/xml/properties/";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://xml.org/sax/features/namespaces", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/default-attribute-values", "http://apache.org/xml/features/validation/validate-content-models", "http://apache.org/xml/features/validation/validate-datatypes", "http://apache.org/xml/features/validation/warn-on-duplicate-attdef", "http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", "http://apache.org/xml/features/nonvalidating/load-external-dtd"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://xml.org/sax/properties/xml-string", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation"};
    private static final boolean PRINT_EXCEPTION_STACK_TRACE = false;
    protected GrammarResolver fGrammarResolver = null;
    protected boolean fParseInProgress = false;
    private boolean fNeedReset = false;
    private boolean fContinueAfterFatalError = false;
    private ErrorHandler fErrorHandler = null;
    private Locale fLocale = null;
    private static XMLMessageProvider fgXMLMessages = new XMLMessages();
    private static XMLMessageProvider fgImplementationMessages = new ImplementationMessages();
    private static XMLMessageProvider fgSchemaMessages = new SchemaMessageProvider();
    private static XMLMessageProvider fgDatatypeMessages = new DatatypeMessageProvider();
    protected StringPool fStringPool = null;
    protected XMLErrorReporter fErrorReporter = null;
    protected DefaultEntityHandler fEntityHandler = null;
    protected XMLDocumentScanner fScanner = null;
    protected XMLValidator fValidator = null;

    protected XMLParser() {
        this(new StringPool());
    }

    protected XMLParser(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fErrorReporter = this;
        this.fEntityHandler = new DefaultEntityHandler(this.fStringPool, this.fErrorReporter);
        this.fScanner = new XMLDocumentScanner(this.fStringPool, this.fErrorReporter, this.fEntityHandler, new ChunkyCharArray(this.fStringPool));
        this.fValidator = new XMLValidator(this.fStringPool, this.fErrorReporter, this.fEntityHandler, this.fScanner);
        this.fGrammarResolver = new GrammarResolverImpl();
        this.fScanner.setGrammarResolver(this.fGrammarResolver);
        this.fValidator.setGrammarResolver(this.fGrammarResolver);
        try {
            this.setNamespaces(true);
        }
        catch (Exception exception) {}
    }

    public void addRecognizer(XMLDeclRecognizer xMLDeclRecognizer) {
        this.fEntityHandler.addRecognizer(xMLDeclRecognizer);
    }

    public abstract void attlistDecl(QName var1, QName var2, int var3, boolean var4, String var5, int var6, int var7) throws Exception;

    public abstract void comment(int var1) throws Exception;

    public abstract void elementDecl(QName var1, int var2, int var3, XMLContentSpec.Provider var4) throws Exception;

    public abstract void endDTD() throws Exception;

    public abstract void externalEntityDecl(int var1, int var2, int var3) throws Exception;

    public abstract void externalPEDecl(int var1, int var2, int var3) throws Exception;

    protected boolean getAllowJavaEncodings() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fEntityHandler.getAllowJavaEncodings();
    }

    protected boolean getContinueAfterFatalError() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fContinueAfterFatalError;
    }

    public EntityResolver getEntityResolver() {
        return this.fEntityHandler.getEntityResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    protected boolean getExternalGeneralEntities() throws SAXNotRecognizedException, SAXNotSupportedException {
        return true;
    }

    protected boolean getExternalParameterEntities() throws SAXNotRecognizedException, SAXNotSupportedException {
        return true;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string2 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string2.equals("validation")) {
                return this.getValidation();
            }
            if (string2.equals("external-general-entities")) {
                return this.getExternalGeneralEntities();
            }
            if (string2.equals("external-parameter-entities")) {
                return this.getExternalParameterEntities();
            }
            if (string2.equals("namespaces")) {
                return this.getNamespaces();
            }
        } else if (string.startsWith(XERCES_FEATURES_PREFIX)) {
            String string3 = string.substring(XERCES_FEATURES_PREFIX.length());
            if (string3.equals("validation/schema")) {
                return this.getValidationSchema();
            }
            if (string3.equals("validation/schema-full-checking")) {
                return this.getValidationSchemaFullChecking();
            }
            if (string3.equals("validation/dynamic")) {
                return this.getValidationDynamic();
            }
            if (string3.equals("validation/default-attribute-values")) {
                throw new SAXNotRecognizedException(string);
            }
            if (string3.equals("validation/normalize-element-contents")) {
                return this.getNormalizeContents();
            }
            if (string3.equals("validation/validate-content-models")) {
                throw new SAXNotRecognizedException(string);
            }
            if (string3.equals("nonvalidating/load-dtd-grammar")) {
                return this.getLoadDTDGrammar();
            }
            if (string3.equals("nonvalidating/load-external-dtd")) {
                return this.getLoadExternalDTD();
            }
            if (string3.equals("validation/validate-datatypes")) {
                throw new SAXNotRecognizedException(string);
            }
            if (string3.equals("validation/warn-on-duplicate-attdef")) {
                return this.getValidationWarnOnDuplicateAttdef();
            }
            if (string3.equals("validation/warn-on-undeclared-elemdef")) {
                return this.getValidationWarnOnUndeclaredElemdef();
            }
            if (string3.equals("allow-java-encodings")) {
                return this.getAllowJavaEncodings();
            }
            if (string3.equals("continue-after-fatal-error")) {
                return this.getContinueAfterFatalError();
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public String[] getFeaturesRecognized() {
        return RECOGNIZED_FEATURES;
    }

    protected boolean getLoadDTDGrammar() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getLoadDTDGrammar();
    }

    protected boolean getLoadExternalDTD() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fScanner.getLoadExternalDTD();
    }

    public final Locator getLocator() {
        return this.fEntityHandler;
    }

    protected boolean getNamespaces() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getNamespacesEnabled();
    }

    protected boolean getNormalizeContents() {
        return this.fValidator.getNormalizeConents();
    }

    public String[] getPropertiesRecognized() {
        return RECOGNIZED_PROPERTIES;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("xml-string")) {
                return this.getXMLString();
            }
        } else if (string.startsWith(XERCES_PROPERTIES_PREFIX)) {
            String string3 = string.substring(XERCES_PROPERTIES_PREFIX.length());
            if (string3.equals("schema/external-schemaLocation")) {
                return this.fValidator.getExternalSchemas();
            }
            if (string3.equals("schema/external-noNamespaceSchemaLocation")) {
                return this.fValidator.getExternalNoNamespaceSchema();
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    protected boolean getValidation() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getValidationEnabled();
    }

    protected boolean getValidationDynamic() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getDynamicValidationEnabled();
    }

    protected boolean getValidationSchema() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getSchemaValidationEnabled();
    }

    protected boolean getValidationSchemaFullChecking() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getSchemaFullCheckingEnabled();
    }

    protected boolean getValidationWarnOnDuplicateAttdef() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getWarningOnDuplicateAttDef();
    }

    protected boolean getValidationWarnOnUndeclaredElemdef() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fValidator.getWarningOnUndeclaredElements();
    }

    protected String getXMLString() throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("http://xml.org/sax/properties/xml-string");
    }

    public final Locale getfLocale() {
        return this.fLocale;
    }

    public final XMLMessageProvider getfgDatatypeMessages() {
        return fgDatatypeMessages;
    }

    public final XMLMessageProvider getfgImplementationMessages() {
        return fgImplementationMessages;
    }

    public final XMLMessageProvider getfgSchemaMessages() {
        return fgSchemaMessages;
    }

    public final XMLMessageProvider getfgXMLMessages() {
        return fgXMLMessages;
    }

    protected void initHandlers(boolean bl, XMLDocumentHandler xMLDocumentHandler, XMLDocumentHandler.DTDHandler dTDHandler) {
        this.fValidator.initHandlers(bl, xMLDocumentHandler, dTDHandler);
        this.fScanner.setDTDHandler(this);
    }

    public abstract void internalEntityDecl(int var1, int var2) throws Exception;

    public abstract void internalPEDecl(int var1, int var2) throws Exception;

    public abstract void internalSubset(int var1) throws Exception;

    public boolean isFeatureRecognized(String string) {
        String[] stringArray = this.getFeaturesRecognized();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isPropertyRecognized(String string) {
        String[] stringArray = this.getPropertiesRecognized();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract void notationDecl(int var1, int var2, int var3) throws Exception;

    public void parse(String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(string);
        try {
            this.parse(inputSource);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                Reader reader = inputSource.getCharacterStream();
                if (reader != null) {
                    reader.close();
                } else {
                    InputStream inputStream = inputSource.getByteStream();
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var4_3 = null;
        try {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                reader.close();
            } else {
                InputStream inputStream = inputSource.getByteStream();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {}
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        if (this.fParseInProgress) {
            throw new SAXException("FWK005 parse may not be called while parsing.");
        }
        try {
            try {
                if (this.parseSomeSetup(inputSource)) {
                    this.fScanner.parseSome(true);
                }
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
            Object var3_5 = null;
            this.fParseInProgress = false;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.fParseInProgress = false;
            throw throwable;
        }
    }

    public boolean parseSome() throws Exception {
        if (!this.fScanner.parseSome(false)) {
            this.fParseInProgress = false;
            return false;
        }
        return true;
    }

    public boolean parseSomeSetup(InputSource inputSource) throws Exception {
        if (this.fNeedReset) {
            this.resetOrCopy();
        }
        this.fParseInProgress = true;
        this.fNeedReset = true;
        return this.fEntityHandler.startReadingFromDocument(inputSource);
    }

    public abstract void processingInstruction(int var1, int var2) throws Exception;

    public void reportError(Locator locator, String string, int n, int n2, Object[] objectArray, int n3) throws Exception {
        SAXParseException sAXParseException;
        if (string.equals("http://www.w3.org/TR/1998/REC-xml-19980210")) {
            sAXParseException = new SAXParseException(fgXMLMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else if (string.equals("http://www.w3.org/TR/1999/REC-xml-names-19990114")) {
            sAXParseException = new SAXParseException(fgXMLMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else if (string.equals("http://www.apache.org/xml/xerces.html")) {
            sAXParseException = new SAXParseException(fgImplementationMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else if (string.equals("http://www.w3.org/TR/xml-schema-1")) {
            sAXParseException = new SAXParseException(fgSchemaMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else if (string.equals("http://www.w3.org/TR/xml-schema-2")) {
            sAXParseException = new SAXParseException(fgDatatypeMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else {
            throw new RuntimeException("FWK007 Unknown error domain \"" + string + "\"." + "\n" + string);
        }
        if (this.fErrorHandler == null) {
            if (n3 == 2 && !this.fContinueAfterFatalError) {
                throw sAXParseException;
            }
            return;
        }
        if (n3 == 0) {
            this.fErrorHandler.warning(sAXParseException);
        } else if (n3 == 2) {
            this.fErrorHandler.fatalError(sAXParseException);
            if (!this.fContinueAfterFatalError) {
                Object[] objectArray2 = new Object[]{sAXParseException.getMessage()};
                throw new SAXException(fgImplementationMessages.createMessage(this.fLocale, 16, 0, objectArray2));
            }
        } else {
            this.fErrorHandler.error(sAXParseException);
        }
    }

    public void reset() throws Exception {
        this.fGrammarResolver.clearGrammarResolver();
        this.fStringPool.reset();
        this.fEntityHandler.reset(this.fStringPool);
        this.fScanner.reset(this.fStringPool, new ChunkyCharArray(this.fStringPool));
        this.fValidator.reset(this.fStringPool);
        this.fNeedReset = false;
    }

    protected void resetOrCopy() throws Exception {
        this.fStringPool = new StringPool();
        this.fEntityHandler.reset(this.fStringPool);
        this.fScanner.reset(this.fStringPool, new ChunkyCharArray(this.fStringPool));
        this.fValidator.resetOrCopy(this.fStringPool);
        this.fNeedReset = false;
        this.fGrammarResolver.clearGrammarResolver();
        this.fScanner.setGrammarResolver(this.fGrammarResolver);
        this.fValidator.setGrammarResolver(this.fGrammarResolver);
    }

    protected void setAllowJavaEncodings(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fEntityHandler.setAllowJavaEncodings(bl);
    }

    protected void setContinueAfterFatalError(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fContinueAfterFatalError = bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fEntityHandler.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    protected void setExternalGeneralEntities(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/external-general-entities): parse is in progress.\nhttp://xml.org/sax/features/external-general-entities");
        }
        if (!bl) {
            throw new SAXNotSupportedException("http://xml.org/sax/features/external-general-entities");
        }
    }

    protected void setExternalNoNamespaceSchemaLocation(Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation:  parse is in progress");
        }
        this.fValidator.setExternalNoNamespaceSchema(object);
    }

    protected void setExternalParameterEntities(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/external-general-entities): parse is in progress.\nhttp://xml.org/sax/features/external-general-entities");
        }
        if (!bl) {
            throw new SAXNotSupportedException("http://xml.org/sax/features/external-parameter-entities");
        }
    }

    protected void setExternalSchemaLocation(Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/properties/validation/schema/external-schemaLocation:  parse is in progress");
        }
        this.fValidator.setExternalSchemas(object);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string2 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string2.equals("validation")) {
                this.setValidation(bl);
                return;
            }
            if (string2.equals("external-general-entities")) {
                this.setExternalGeneralEntities(bl);
                return;
            }
            if (string2.equals("external-parameter-entities")) {
                this.setExternalParameterEntities(bl);
                return;
            }
            if (string2.equals("namespaces")) {
                this.setNamespaces(bl);
                return;
            }
        } else if (string.startsWith(XERCES_FEATURES_PREFIX)) {
            String string3 = string.substring(XERCES_FEATURES_PREFIX.length());
            if (string3.equals("validation/schema")) {
                this.setValidationSchema(bl);
                return;
            }
            if (string3.equals("validation/schema-full-checking")) {
                this.setValidationSchemaFullChecking(bl);
                return;
            }
            if (string3.equals("validation/dynamic")) {
                this.setValidationDynamic(bl);
                return;
            }
            if (string3.equals("validation/default-attribute-values")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("schema/expose-normalized-values")) {
                this.setNormalizeContents(bl);
                return;
            }
            if (string3.equals("validation/normalize-attribute-values")) {
                this.setNormalizeAttributeValues(bl);
            }
            if (string3.equals("validation/validate-content-models")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("nonvalidating/load-dtd-grammar")) {
                this.setLoadDTDGrammar(bl);
                return;
            }
            if (string3.equals("nonvalidating/load-external-dtd")) {
                this.setLoadExternalDTD(bl);
                return;
            }
            if (string3.equals("validation/validate-datatypes")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("validation/warn-on-duplicate-attdef")) {
                this.setValidationWarnOnDuplicateAttdef(bl);
                return;
            }
            if (string3.equals("validation/warn-on-undeclared-elemdef")) {
                this.setValidationWarnOnUndeclaredElemdef(bl);
                return;
            }
            if (string3.equals("allow-java-encodings")) {
                this.setAllowJavaEncodings(bl);
                return;
            }
            if (string3.equals("continue-after-fatal-error")) {
                this.setContinueAfterFatalError(bl);
                return;
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    protected void setLoadDTDGrammar(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/nonvalidating/load-dtd-grammar: parse is in progress");
        }
        try {
            this.fValidator.setLoadDTDGrammar(bl);
        }
        catch (Exception exception) {
            throw new SAXNotSupportedException(exception.getMessage());
        }
    }

    protected void setLoadExternalDTD(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/nonvalidating/load-external-dtd: parse is in progress");
        }
        try {
            this.fScanner.setLoadExternalDTD(bl);
        }
        catch (Exception exception) {
            throw new SAXNotSupportedException(exception.getMessage());
        }
    }

    public void setLocale(Locale locale) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXException("FWK006 setLocale may not be called while parsing");
        }
        this.fLocale = locale;
        fgXMLMessages.setLocale(locale);
        fgImplementationMessages.setLocale(locale);
    }

    protected void setNamespaces(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/namespaces): parse is in progress.\nhttp://xml.org/sax/features/namespaces");
        }
        this.fScanner.setNamespacesEnabled(bl);
        this.fValidator.setNamespacesEnabled(bl);
    }

    protected void setNormalizeAttributeValues(boolean bl) {
        this.fValidator.setNormalizeAttributeValues(bl);
    }

    protected void setNormalizeContents(boolean bl) {
        this.fValidator.setNormalizeContents(bl);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string2;
        if (string.startsWith(SAX2_PROPERTIES_PREFIX) && (string2 = string.substring(SAX2_PROPERTIES_PREFIX.length())).equals("xml-string")) {
            throw new SAXNotSupportedException(string);
        }
        if (string.startsWith(XERCES_PROPERTIES_PREFIX)) {
            string2 = string.substring(XERCES_PROPERTIES_PREFIX.length());
            if (string2.equals("schema/external-schemaLocation")) {
                this.setExternalSchemaLocation(object);
                return;
            }
            if (string2.equals("schema/external-noNamespaceSchemaLocation")) {
                this.setExternalNoNamespaceSchemaLocation(object);
                return;
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setReaderFactory(XMLEntityReaderFactory xMLEntityReaderFactory) {
        this.fEntityHandler.setReaderFactory(xMLEntityReaderFactory);
    }

    protected void setValidation(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("PAR004 Cannot setFeature(http://xml.org/sax/features/validation): parse is in progress.\nhttp://xml.org/sax/features/validation");
        }
        try {
            this.fScanner.setValidationEnabled(bl);
            this.fValidator.setValidationEnabled(bl);
        }
        catch (Exception exception) {
            throw new SAXNotSupportedException(exception.getMessage());
        }
    }

    protected void setValidationDynamic(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/validation/dynamic: parse is in progress");
        }
        try {
            this.fValidator.setDynamicValidationEnabled(bl);
        }
        catch (Exception exception) {
            throw new SAXNotSupportedException(exception.getMessage());
        }
    }

    protected void setValidationSchema(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/validation/schema: parse is in progress");
        }
        this.fValidator.setSchemaValidationEnabled(bl);
    }

    protected void setValidationSchemaFullChecking(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/validation/schema-full-checking:  parse is in progress");
        }
        this.fValidator.setSchemaFullCheckingEnabled(bl);
    }

    protected void setValidationWarnOnDuplicateAttdef(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fValidator.setWarningOnDuplicateAttDef(bl);
    }

    protected void setValidationWarnOnUndeclaredElemdef(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fValidator.setWarningOnUndeclaredElements(bl);
    }

    public abstract void startDTD(QName var1, int var2, int var3) throws Exception;

    public abstract void textDecl(int var1, int var2) throws Exception;

    public abstract void unparsedEntityDecl(int var1, int var2, int var3, int var4) throws Exception;
}

