/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.InternalApi;
import com.google.api.gax.logging.LogData;
import com.google.api.gax.logging.LoggerProvider;
import com.google.api.gax.logging.LoggingUtils;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class GrpcLoggingInterceptor
implements ClientInterceptor {
    private static final LoggerProvider LOGGER_PROVIDER = LoggerProvider.forClazz(GrpcLoggingInterceptor.class);
    ClientCall.Listener<?> currentListener;

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
            LogData.Builder logDataBuilder;
            {
                super(delegate);
                this.logDataBuilder = LogData.builder();
            }

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                LoggingUtils.recordServiceRpcAndRequestHeaders((String)method.getServiceName(), (String)method.getFullMethodName(), null, (Map)GrpcLoggingInterceptor.metadataHeadersToMap(headers), (LogData.Builder)this.logDataBuilder, (LoggerProvider)LOGGER_PROVIDER);
                ForwardingClientCallListener.SimpleForwardingClientCallListener responseLoggingListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata headers) {
                        LoggingUtils.recordResponseHeaders((Map)GrpcLoggingInterceptor.metadataHeadersToMap(headers), (LogData.Builder)logDataBuilder, (LoggerProvider)LOGGER_PROVIDER);
                        super.onHeaders(headers);
                    }

                    public void onMessage(RespT message) {
                        LoggingUtils.recordResponsePayload(message, (LogData.Builder)logDataBuilder, (LoggerProvider)LOGGER_PROVIDER);
                        super.onMessage(message);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        LoggingUtils.logResponse((String)status.getCode().toString(), (LogData.Builder)logDataBuilder, (LoggerProvider)LOGGER_PROVIDER);
                        super.onClose(status, trailers);
                    }
                };
                GrpcLoggingInterceptor.this.currentListener = responseLoggingListener;
                super.start((ClientCall.Listener)responseLoggingListener, headers);
            }

            public void sendMessage(ReqT message) {
                LoggingUtils.logRequest(message, (LogData.Builder)this.logDataBuilder, (LoggerProvider)LOGGER_PROVIDER);
                super.sendMessage(message);
            }
        };
    }

    private static Map<String, String> metadataHeadersToMap(Metadata headers) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        LoggingUtils.executeWithTryCatch(() -> {
            for (String key : headers.keys()) {
                if (key.endsWith("-bin")) continue;
                Metadata.Key metadataKey = Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                String headerValue = (String)headers.get(metadataKey);
                headersMap.put(key, headerValue);
            }
        });
        return headersMap;
    }
}

