/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.internal.circuitbreaker;

import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.internal.circuitbreaker.AcquireResponse;
import software.amazon.awssdk.retries.internal.circuitbreaker.ReleaseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class TokenBucket {
    private final int maxCapacity;
    private final AtomicInteger capacity;

    TokenBucket(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.capacity = new AtomicInteger(maxCapacity);
    }

    public AcquireResponse tryAcquire(int amountToAcquire) {
        int newCapacity;
        int currentCapacity;
        Validate.isNotNegative((int)amountToAcquire, (String)"amountToAcquire");
        AcquireResponse.Builder responseBuilder = AcquireResponse.builder().maxCapacity(this.maxCapacity).capacityRequested(amountToAcquire);
        if (amountToAcquire == 0) {
            return responseBuilder.acquisitionFailed(false).capacityAcquired(0).capacityRemaining(this.capacity.get()).build();
        }
        do {
            if ((newCapacity = (currentCapacity = this.capacity.get()) - amountToAcquire) >= 0) continue;
            return responseBuilder.acquisitionFailed(true).capacityAcquired(0).capacityRemaining(this.capacity.get()).build();
        } while (!this.capacity.compareAndSet(currentCapacity, newCapacity));
        return responseBuilder.acquisitionFailed(false).capacityAcquired(amountToAcquire).capacityRemaining(newCapacity).build();
    }

    public ReleaseResponse release(int amountToRelease) {
        int newCapacity;
        int currentCapacity;
        Validate.isTrue((amountToRelease >= 0 ? 1 : 0) != 0, (String)"Amount must not be negative.", (Object[])new Object[0]);
        ReleaseResponse.Builder builder = ReleaseResponse.builder().capacityReleased(amountToRelease).maxCapacity(this.maxCapacity);
        if (amountToRelease == 0) {
            return builder.currentCapacity(this.capacity.get()).build();
        }
        while (!this.capacity.compareAndSet(currentCapacity = this.capacity.get(), newCapacity = Math.min(currentCapacity + amountToRelease, this.maxCapacity))) {
        }
        return builder.currentCapacity(newCapacity).build();
    }

    public int currentCapacity() {
        return this.capacity.get();
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public String toString() {
        return ToString.builder((String)"TokenBucket").add("maxCapacity", (Object)this.maxCapacity).add("capacity", (Object)this.capacity).build();
    }
}

