/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.template;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jxls.area.Area;
import org.jxls.builder.xls.XlsCommentAreaBuilder;
import org.jxls.command.GridCommand;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.JxlsException;
import org.jxls.transform.Transformer;
import org.jxls.util.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExporter {
    public static final String GRID_TEMPLATE_XLS = "grid_template.xls";
    static Logger logger = LoggerFactory.getLogger(SimpleExporter.class);
    private byte[] templateBytes;

    public void registerGridTemplate(InputStream inputStream) throws IOException {
        int count;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((count = inputStream.read(data)) != -1) {
            os.write(data, 0, count);
        }
        this.templateBytes = os.toByteArray();
    }

    public void gridExport(Iterable<?> headers, Iterable<?> dataObjects, String objectProps, OutputStream outputStream) {
        InputStream is;
        if (this.templateBytes == null) {
            is = SimpleExporter.class.getResourceAsStream(GRID_TEMPLATE_XLS);
            try {
                this.registerGridTemplate(is);
            }
            catch (IOException e) {
                throw new JxlsException("Failed to read default template file grid_template.xls", e);
            }
        }
        is = new ByteArrayInputStream(this.templateBytes);
        Transformer transformer = TransformerFactory.createTransformer(is, outputStream);
        XlsCommentAreaBuilder areaBuilder = new XlsCommentAreaBuilder(transformer);
        List<Area> xlsAreaList = areaBuilder.build();
        Area xlsArea = xlsAreaList.get(0);
        Context context = new Context();
        context.putVar("headers", headers);
        context.putVar("data", dataObjects);
        GridCommand gridCommand = (GridCommand)xlsArea.getCommandDataList().get(0).getCommand();
        gridCommand.setProps(objectProps);
        xlsArea.applyAt(new CellRef("Sheet1!A1"), context);
        try {
            transformer.write();
        }
        catch (IOException e) {
            throw new JxlsException("Failed to write to output stream", e);
        }
    }
}

