/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;

public final class LightSettingsColor {
    @Key(value="red")
    private final Float red;
    @Key(value="green")
    private final Float green;
    @Key(value="blue")
    private final Float blue;
    @Key(value="alpha")
    private final Float alpha;

    public LightSettingsColor(float red, float green, float blue, float alpha) {
        this.red = Float.valueOf(red);
        this.green = Float.valueOf(green);
        this.blue = Float.valueOf(blue);
        this.alpha = Float.valueOf(alpha);
    }

    public static LightSettingsColor fromString(String rrggbb) {
        Preconditions.checkArgument((boolean)rrggbb.matches("^#[0-9a-fA-F]{6}$"), (Object)"LightSettingsColor must be in the form #RRGGBB");
        float red = (float)Integer.parseInt(rrggbb.substring(1, 3), 16) / 255.0f;
        float green = (float)Integer.valueOf(rrggbb.substring(3, 5), 16).intValue() / 255.0f;
        float blue = (float)Integer.valueOf(rrggbb.substring(5, 7), 16).intValue() / 255.0f;
        return new LightSettingsColor(red, green, blue, 1.0f);
    }
}

