/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.firebase.messaging.LightSettingsColor;
import java.util.concurrent.TimeUnit;

public final class LightSettings {
    @Key(value="color")
    private final LightSettingsColor color;
    @Key(value="light_on_duration")
    private final String lightOnDuration;
    @Key(value="light_off_duration")
    private final String lightOffDuration;

    private LightSettings(Builder builder) {
        this.color = builder.color;
        this.lightOnDuration = builder.lightOnDuration;
        this.lightOffDuration = builder.lightOffDuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LightSettingsColor color;
        private String lightOnDuration;
        private String lightOffDuration;

        private Builder() {
        }

        public Builder setColorFromString(String color) {
            this.color = LightSettingsColor.fromString(color);
            return this;
        }

        public Builder setColor(LightSettingsColor color) {
            this.color = color;
            return this;
        }

        public Builder setLightOnDurationInMillis(long lightOnDurationInMillis) {
            this.lightOnDuration = this.convertToSecondsAndNanosFormat(lightOnDurationInMillis);
            return this;
        }

        public Builder setLightOffDurationInMillis(long lightOffDurationInMillis) {
            this.lightOffDuration = this.convertToSecondsAndNanosFormat(lightOffDurationInMillis);
            return this;
        }

        private String convertToSecondsAndNanosFormat(long millis) {
            Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"Milliseconds duration must not be negative");
            long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
            long subsecondNanos = TimeUnit.MILLISECONDS.toNanos(millis - seconds * 1000L);
            if (subsecondNanos > 0L) {
                return String.format("%d.%09ds", seconds, subsecondNanos);
            }
            return String.format("%ds", seconds);
        }

        public LightSettings build() {
            return new LightSettings(this);
        }
    }
}

