/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Clock;
import com.google.api.client.util.StringUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.internal.CryptoSigner;
import com.google.firebase.auth.internal.FirebaseCustomAuthToken;
import com.google.firebase.internal.Nullable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class FirebaseTokenFactory {
    private final JsonFactory jsonFactory;
    private final Clock clock;
    private final CryptoSigner signer;
    private final String tenantId;

    public FirebaseTokenFactory(JsonFactory jsonFactory, Clock clock, CryptoSigner signer, @Nullable String tenantId) {
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.signer = (CryptoSigner)Preconditions.checkNotNull((Object)signer);
        this.tenantId = tenantId;
    }

    @VisibleForTesting
    FirebaseTokenFactory(JsonFactory jsonFactory, Clock clock, CryptoSigner signer) {
        this(jsonFactory, clock, signer, null);
    }

    String createSignedCustomAuthTokenForUser(String uid) throws FirebaseAuthException {
        return this.createSignedCustomAuthTokenForUser(uid, null);
    }

    public String createSignedCustomAuthTokenForUser(String uid, Map<String, Object> developerClaims) throws FirebaseAuthException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"Uid must be provided.");
        Preconditions.checkArgument((uid.length() <= 128 ? 1 : 0) != 0, (Object)"Uid must be shorter than 128 characters.");
        JsonWebSignature.Header header = new JsonWebSignature.Header().setAlgorithm("RS256");
        long issuedAt = this.clock.currentTimeMillis() / 1000L;
        FirebaseCustomAuthToken.Payload payload = new FirebaseCustomAuthToken.Payload().setUid(uid).setIssuer(this.signer.getAccount()).setSubject(this.signer.getAccount()).setAudience("https://identitytoolkit.googleapis.com/google.identity.identitytoolkit.v1.IdentityToolkit").setIssuedAtTimeSeconds(issuedAt).setExpirationTimeSeconds(issuedAt + 3600L);
        if (!Strings.isNullOrEmpty((String)this.tenantId)) {
            payload.setTenantId(this.tenantId);
        }
        if (developerClaims != null) {
            Collection reservedNames = payload.getClassInfo().getNames();
            for (String key : developerClaims.keySet()) {
                if (!reservedNames.contains(key)) continue;
                throw new IllegalArgumentException(String.format("developerClaims must not contain a reserved key: %s", key));
            }
            GenericJson jsonObject = new GenericJson();
            jsonObject.putAll(developerClaims);
            payload.setDeveloperClaims(jsonObject);
        }
        return this.signPayload(header, payload);
    }

    private String signPayload(JsonWebSignature.Header header, FirebaseCustomAuthToken.Payload payload) throws FirebaseAuthException {
        String content = this.encodePayload(header, payload);
        byte[] contentBytes = StringUtils.getBytesUtf8((String)content);
        String signature = Base64.encodeBase64URLSafeString((byte[])this.signer.sign(contentBytes));
        return content + "." + signature;
    }

    private String encodePayload(JsonWebSignature.Header header, FirebaseCustomAuthToken.Payload payload) {
        try {
            String headerString = Base64.encodeBase64URLSafeString((byte[])this.jsonFactory.toByteArray((Object)header));
            String payloadString = Base64.encodeBase64URLSafeString((byte[])this.jsonFactory.toByteArray((Object)payload));
            return headerString + "." + payloadString;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to encode JWT with the given claims: " + e.getMessage(), e);
        }
    }
}

