/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.app.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.IncludeEventHandler;
import org.apache.velocity.app.event.InvalidReferenceEventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalEventContext;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCartridge {
    private List<ReferenceInsertionEventHandler> referenceHandlers = new ArrayList<ReferenceInsertionEventHandler>();
    private MethodExceptionEventHandler methodExceptionHandler = null;
    private List<IncludeEventHandler> includeHandlers = new ArrayList<IncludeEventHandler>();
    private List<InvalidReferenceEventHandler> invalidReferenceHandlers = new ArrayList<InvalidReferenceEventHandler>();
    Set<EventHandler> initializedHandlers = new HashSet<EventHandler>();
    protected RuntimeServices rsvc = null;

    protected Logger getLog() {
        return this.rsvc == null ? LoggerFactory.getLogger(EventCartridge.class) : this.rsvc.getLog();
    }

    public synchronized void setRuntimeServices(RuntimeServices rs) {
        if (this.rsvc == null) {
            this.rsvc = rs;
            for (EventHandler eventHandler : this.referenceHandlers) {
                if (!(eventHandler instanceof RuntimeServicesAware) || this.initializedHandlers.contains(eventHandler)) continue;
                ((RuntimeServicesAware)((Object)eventHandler)).setRuntimeServices(rs);
                this.initializedHandlers.add(eventHandler);
            }
            if (this.methodExceptionHandler != null && this.methodExceptionHandler instanceof RuntimeServicesAware && !this.initializedHandlers.contains(this.methodExceptionHandler)) {
                ((RuntimeServicesAware)((Object)this.methodExceptionHandler)).setRuntimeServices(rs);
                this.initializedHandlers.add(this.methodExceptionHandler);
            }
            for (EventHandler eventHandler : this.includeHandlers) {
                if (!(eventHandler instanceof RuntimeServicesAware) || this.initializedHandlers.contains(eventHandler)) continue;
                ((RuntimeServicesAware)((Object)eventHandler)).setRuntimeServices(rs);
                this.initializedHandlers.add(eventHandler);
            }
            for (EventHandler eventHandler : this.invalidReferenceHandlers) {
                if (!(eventHandler instanceof RuntimeServicesAware) || this.initializedHandlers.contains(eventHandler)) continue;
                ((RuntimeServicesAware)((Object)eventHandler)).setRuntimeServices(rs);
                this.initializedHandlers.add(eventHandler);
            }
        } else if (this.rsvc != rs) {
            throw new VelocityException("an event cartridge cannot be used by several different runtime services instances");
        }
    }

    public boolean addEventHandler(EventHandler ev) {
        if (ev == null) {
            return false;
        }
        boolean found = false;
        if (ev instanceof ReferenceInsertionEventHandler) {
            this.addReferenceInsertionEventHandler((ReferenceInsertionEventHandler)ev);
            found = true;
        }
        if (ev instanceof MethodExceptionEventHandler) {
            this.addMethodExceptionHandler((MethodExceptionEventHandler)ev);
            found = true;
        }
        if (ev instanceof IncludeEventHandler) {
            this.addIncludeEventHandler((IncludeEventHandler)ev);
            found = true;
        }
        if (ev instanceof InvalidReferenceEventHandler) {
            this.addInvalidReferenceEventHandler((InvalidReferenceEventHandler)ev);
            found = true;
        }
        if (found && this.rsvc != null && ev instanceof RuntimeServicesAware && !this.initializedHandlers.contains(ev)) {
            ((RuntimeServicesAware)((Object)ev)).setRuntimeServices(this.rsvc);
            this.initializedHandlers.add(ev);
        }
        return found;
    }

    public void addReferenceInsertionEventHandler(ReferenceInsertionEventHandler ev) {
        this.referenceHandlers.add(ev);
    }

    public void addMethodExceptionHandler(MethodExceptionEventHandler ev) {
        if (this.methodExceptionHandler == null) {
            this.methodExceptionHandler = ev;
        } else {
            this.getLog().warn("ignoring extra method exception handler");
        }
    }

    public void addIncludeEventHandler(IncludeEventHandler ev) {
        this.includeHandlers.add(ev);
    }

    public void addInvalidReferenceEventHandler(InvalidReferenceEventHandler ev) {
        this.invalidReferenceHandlers.add(ev);
    }

    public boolean removeEventHandler(EventHandler ev) {
        if (ev == null) {
            return false;
        }
        if (ev instanceof ReferenceInsertionEventHandler) {
            return this.referenceHandlers.remove(ev);
        }
        if (ev instanceof MethodExceptionEventHandler && ev == this.methodExceptionHandler) {
            this.methodExceptionHandler = null;
            return true;
        }
        if (ev instanceof IncludeEventHandler) {
            return this.includeHandlers.remove(ev);
        }
        if (ev instanceof InvalidReferenceEventHandler) {
            return this.invalidReferenceHandlers.remove(ev);
        }
        return false;
    }

    public Object referenceInsert(InternalContextAdapter context, String reference, Object value) {
        for (ReferenceInsertionEventHandler handler : this.referenceHandlers) {
            value = handler.referenceInsert(context, reference, value);
        }
        return value;
    }

    boolean hasMethodExceptionEventHandler() {
        return this.methodExceptionHandler != null;
    }

    public Object methodException(Context context, Class<?> claz, String method, Exception e, Info info) {
        if (this.methodExceptionHandler != null) {
            return this.methodExceptionHandler.methodException(context, claz, method, e, info);
        }
        return null;
    }

    public String includeEvent(Context context, String includeResourcePath, String currentResourcePath, String directiveName) {
        IncludeEventHandler handler;
        Iterator<IncludeEventHandler> iterator = this.includeHandlers.iterator();
        while (iterator.hasNext() && (includeResourcePath = (handler = iterator.next()).includeEvent(context, includeResourcePath, currentResourcePath, directiveName)) != null) {
        }
        return includeResourcePath;
    }

    public Object invalidGetMethod(Context context, String reference, Object object, String property, Info info) {
        InvalidReferenceEventHandler handler;
        Object result = null;
        Iterator<InvalidReferenceEventHandler> iterator = this.invalidReferenceHandlers.iterator();
        while (iterator.hasNext() && (result = (handler = iterator.next()).invalidGetMethod(context, reference, object, property, info)) == null) {
        }
        return result;
    }

    public boolean invalidSetMethod(Context context, String leftreference, String rightreference, Info info) {
        for (InvalidReferenceEventHandler handler : this.invalidReferenceHandlers) {
            if (!handler.invalidSetMethod(context, leftreference, rightreference, info)) continue;
            return true;
        }
        return false;
    }

    public Object invalidMethod(Context context, String reference, Object object, String method, Info info) {
        InvalidReferenceEventHandler handler;
        Object result = null;
        Iterator<InvalidReferenceEventHandler> iterator = this.invalidReferenceHandlers.iterator();
        while (iterator.hasNext() && (result = (handler = iterator.next()).invalidMethod(context, reference, object, method, info)) == null) {
        }
        return result;
    }

    public final boolean attachToContext(Context context) {
        if (context instanceof InternalEventContext) {
            InternalEventContext iec = (InternalEventContext)((Object)context);
            iec.attachEventCartridge(this);
            return true;
        }
        return false;
    }
}

