/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.mariadb.jdbc.client.util.ClosableLock;

public final class SchedulerProvider {
    private static ScheduledThreadPoolExecutor timeoutScheduler;

    public static ScheduledThreadPoolExecutor getTimeoutScheduler(ClosableLock lock) {
        if (timeoutScheduler == null) {
            try (ClosableLock ignore = lock.closeableLock();){
                if (timeoutScheduler == null) {
                    timeoutScheduler = new ScheduledThreadPoolExecutor(1, runnable -> {
                        Thread result = Executors.defaultThreadFactory().newThread(runnable);
                        result.setName("MariaDb-timeout");
                        result.setDaemon(true);
                        return result;
                    });
                    timeoutScheduler.setRemoveOnCancelPolicy(true);
                }
            }
        }
        return timeoutScheduler;
    }
}

