/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.auth;

import com.hivemq.client.internal.mqtt.exceptions.MqttClientStateExceptions;
import com.hivemq.client.internal.mqtt.handler.auth.AbstractMqttAuthHandler;
import com.hivemq.client.internal.mqtt.handler.auth.MqttConnectAuthHandler;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectEvent;
import com.hivemq.client.internal.mqtt.handler.disconnect.MqttDisconnectUtil;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuth;
import com.hivemq.client.internal.mqtt.message.auth.MqttAuthBuilder;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.rx.CompletableFlow;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5AuthException;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5AuthReasonCode;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConnectionScope
public class MqttReAuthHandler
extends AbstractMqttAuthHandler {
    @Nullable
    private CompletableFlow flow;

    MqttReAuthHandler(@NotNull MqttConnectAuthHandler connectAuthHandler) {
        super(connectAuthHandler.clientConfig, connectAuthHandler.authMechanism);
    }

    void reauth(@NotNull CompletableFlow flow) {
        if (!this.clientConfig.executeInEventLoop(() -> this.writeReAuth(flow))) {
            flow.onError(MqttClientStateExceptions.notConnected());
        }
    }

    private void writeReAuth(@NotNull CompletableFlow flow) {
        if (this.ctx == null) {
            flow.onError(MqttClientStateExceptions.notConnected());
            return;
        }
        if (this.state != AbstractMqttAuthHandler.MqttAuthState.NONE) {
            flow.onError(new UnsupportedOperationException("Reauth is still pending."));
            return;
        }
        this.flow = flow;
        MqttAuthBuilder authBuilder = new MqttAuthBuilder(Mqtt5AuthReasonCode.REAUTHENTICATE, this.getMethod());
        this.state = AbstractMqttAuthHandler.MqttAuthState.IN_PROGRESS_INIT;
        this.callMechanismFuture(() -> this.authMechanism.onReAuth(this.clientConfig, authBuilder), ctx -> {
            this.state = AbstractMqttAuthHandler.MqttAuthState.WAIT_FOR_SERVER;
            ctx.writeAndFlush((Object)authBuilder.build()).addListener((GenericFutureListener)this);
        }, (ctx, throwable) -> {
            this.callMechanism(() -> this.authMechanism.onReAuthError(this.clientConfig, (Throwable)throwable));
            this.state = AbstractMqttAuthHandler.MqttAuthState.NONE;
            this.flow.onError((Throwable)throwable);
            this.flow = null;
        });
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof MqttAuth) {
            this.readAuth(ctx, (MqttAuth)msg);
        } else if (msg instanceof MqttDisconnect) {
            this.readDisconnect(ctx, (MqttDisconnect)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    @Override
    void readAuthSuccess(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuth auth) {
        if (this.state != AbstractMqttAuthHandler.MqttAuthState.WAIT_FOR_SERVER) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5AuthException(auth, "Must not receive AUTH with reason code SUCCESS if client side AUTH is pending."));
            return;
        }
        this.state = AbstractMqttAuthHandler.MqttAuthState.IN_PROGRESS_DONE;
        this.callMechanismFutureResult(() -> this.authMechanism.onReAuthSuccess(this.clientConfig, auth), ctx2 -> {
            this.state = AbstractMqttAuthHandler.MqttAuthState.NONE;
            if (this.flow != null) {
                if (!this.flow.isCancelled()) {
                    this.flow.onComplete();
                } else {
                    LOGGER.warn("Reauth was successful but the Completable has been cancelled.");
                }
                this.flow = null;
            }
        }, (ctx2, throwable) -> MqttDisconnectUtil.disconnect(ctx2.channel(), Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, new Mqtt5AuthException(auth, "Server AUTH with reason code SUCCESS not accepted.")));
    }

    @Override
    void readReAuth(@NotNull ChannelHandlerContext ctx, @NotNull MqttAuth auth) {
        if (!this.clientConfig.getAdvancedConfig().isAllowServerReAuth()) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5AuthException(auth, "Must not receive AUTH with reason code REAUTHENTICATE."));
            return;
        }
        if (this.state != AbstractMqttAuthHandler.MqttAuthState.NONE) {
            MqttDisconnectUtil.disconnect(ctx.channel(), Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, new Mqtt5AuthException(auth, "Must not receive AUTH with reason code REAUTHENTICATE if reauth is still pending."));
            return;
        }
        MqttAuthBuilder authBuilder = new MqttAuthBuilder(Mqtt5AuthReasonCode.CONTINUE_AUTHENTICATION, this.getMethod());
        this.state = AbstractMqttAuthHandler.MqttAuthState.IN_PROGRESS_INIT;
        this.callMechanismFutureResult(() -> this.authMechanism.onServerReAuth(this.clientConfig, auth, authBuilder), ctx2 -> {
            this.state = AbstractMqttAuthHandler.MqttAuthState.WAIT_FOR_SERVER;
            ctx2.writeAndFlush((Object)authBuilder.build()).addListener((GenericFutureListener)this);
        }, (ctx2, throwable) -> MqttDisconnectUtil.disconnect(ctx2.channel(), Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, new Mqtt5AuthException(auth, "Server AUTH with reason code REAUTHENTICATE not accepted.")));
    }

    private void readDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnect disconnect) {
        this.cancelTimeout();
        if (this.state != AbstractMqttAuthHandler.MqttAuthState.NONE) {
            this.callMechanism(() -> this.authMechanism.onReAuthRejected(this.clientConfig, disconnect));
            this.state = AbstractMqttAuthHandler.MqttAuthState.NONE;
        }
        ctx.fireChannelRead((Object)disconnect);
    }

    @Override
    protected void onDisconnectEvent(@NotNull ChannelHandlerContext ctx, @NotNull MqttDisconnectEvent disconnectEvent) {
        super.onDisconnectEvent(ctx, disconnectEvent);
        if (this.state != AbstractMqttAuthHandler.MqttAuthState.NONE) {
            this.callMechanism(() -> this.authMechanism.onReAuthError(this.clientConfig, disconnectEvent.getCause()));
            this.state = AbstractMqttAuthHandler.MqttAuthState.NONE;
        }
        if (this.flow != null) {
            this.flow.onError(disconnectEvent.getCause());
            this.flow = null;
        }
    }

    @Override
    @NotNull
    protected String getTimeoutReasonString() {
        return "Timeout while waiting for AUTH or DISCONNECT.";
    }
}

