/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoders;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt3.Mqtt3ClientMessageDecoders;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt5.Mqtt5ClientMessageDecoders;
import com.hivemq.client.internal.mqtt.codec.encoder.MqttMessageEncoders;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt3.Mqtt3ClientMessageEncoders;
import com.hivemq.client.internal.mqtt.codec.encoder.mqtt5.Mqtt5ClientMessageEncoders;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import dagger.Lazy;
import dagger.Module;
import dagger.Provides;
import org.jetbrains.annotations.NotNull;

@Module
public abstract class MqttCodecModule {
    @Provides
    @ConnectionScope
    @NotNull
    static MqttMessageDecoders provideMessageDecoders(@NotNull MqttClientConfig clientConfig, @NotNull Lazy<Mqtt5ClientMessageDecoders> mqtt5ClientMessageDecoders, @NotNull Lazy<Mqtt3ClientMessageDecoders> mqtt3ClientMessageDecoders) {
        switch (clientConfig.getMqttVersion()) {
            case MQTT_5_0: {
                return (MqttMessageDecoders)mqtt5ClientMessageDecoders.get();
            }
            case MQTT_3_1_1: {
                return (MqttMessageDecoders)mqtt3ClientMessageDecoders.get();
            }
        }
        throw new IllegalStateException();
    }

    @Provides
    @ConnectionScope
    @NotNull
    static MqttMessageEncoders provideMessageEncoders(@NotNull MqttClientConfig clientConfig, @NotNull Lazy<Mqtt5ClientMessageEncoders> mqtt5ClientMessageEncoders, @NotNull Lazy<Mqtt3ClientMessageEncoders> mqtt3ClientMessageEncoders) {
        switch (clientConfig.getMqttVersion()) {
            case MQTT_5_0: {
                return (MqttMessageEncoders)mqtt5ClientMessageEncoders.get();
            }
            case MQTT_3_1_1: {
                return (MqttMessageEncoders)mqtt3ClientMessageEncoders.get();
            }
        }
        throw new IllegalStateException();
    }
}

