/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.storage.query;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.traccar.helper.ReflectionCache;

public abstract class Columns {
    public abstract List<String> getColumns(Class<?> var1, String var2);

    protected List<String> getAllColumns(Class<?> clazz, String type) {
        return ReflectionCache.getProperties(clazz, type).entrySet().stream().filter(entry -> !((ReflectionCache.PropertyMethod)entry.getValue()).queryIgnore()).map(Map.Entry::getKey).toList();
    }

    public static class Exclude
    extends Columns {
        private final Set<String> columns;

        public Exclude(String ... columns) {
            this.columns = Arrays.stream(columns).collect(Collectors.toSet());
        }

        @Override
        public List<String> getColumns(Class<?> clazz, String type) {
            return this.getAllColumns(clazz, type).stream().filter(column -> !this.columns.contains(column)).collect(Collectors.toList());
        }
    }

    public static class Include
    extends Columns {
        private final List<String> columns;

        public Include(String ... columns) {
            this.columns = Arrays.stream(columns).collect(Collectors.toList());
        }

        @Override
        public List<String> getColumns(Class<?> clazz, String type) {
            return this.columns;
        }
    }

    public static class All
    extends Columns {
        @Override
        public List<String> getColumns(Class<?> clazz, String type) {
            return this.getAllColumns(clazz, type);
        }
    }
}

