/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Pt60ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_G_TRACK = 6;
    public static final int MSG_G_STEP_COUNT = 13;
    public static final int MSG_G_HEART_RATE = 14;
    public static final int MSG_B_POSITION = 1;
    private static final Pattern PATTERN = new PatternBuilder().expression("@(.)#@[,|]").number("V?dd[,|]").number("(d+)[,|]").number("(d+)[,|]").number("d+[,|]").groupBegin().expression("[^,|]+[,|]").optional().number("[01][,|]").number("d+[,|]").groupEnd("?").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)[,|]").expression("(.*)").expression("[,|]").compile();

    public Pt60ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, String format, int type, String imei) {
        if (channel != null) {
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String message = format.equals("G") ? String.format("@G#@,V01,38,%s,@R#@", time) : String.format("@B#@|01|%03d|%s|0|%s|@E#@", type + 1, imei, time);
            channel.writeAndFlush((Object)new NetworkMessage(message, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        String format = parser.next();
        int type = parser.nextInt();
        String imei = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        this.sendResponse(channel, remoteAddress, format, type, imei);
        if (format.equals("G")) {
            if (type != 6 && type != 13 && type != 14) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setDeviceTime(parser.nextDateTime());
            String[] values = parser.next().split(",");
            if (type == 6) {
                position.setValid(true);
                position.setFixTime(position.getDeviceTime());
                String[] coordinates = values[0].split(";");
                position.setLatitude(Double.parseDouble(coordinates[0]));
                position.setLongitude(Double.parseDouble(coordinates[1]));
            } else {
                this.getLastLocation(position, position.getDeviceTime());
                switch (type) {
                    case 13: {
                        position.set("steps", Integer.parseInt(values[0]));
                        break;
                    }
                    case 14: {
                        position.set("heartRate", Integer.parseInt(values[0]));
                        position.set("battery", Integer.parseInt(values[1]));
                        break;
                    }
                }
            }
            return position;
        }
        if (type != 1) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setDeviceTime(parser.nextDateTime());
        String[] values = parser.next().split("\\|");
        if (Integer.parseInt(values[values.length - 1]) == 2) {
            this.getLastLocation(position, position.getDeviceTime());
            Network network = new Network();
            for (int i = 0; i < values.length - 1; ++i) {
                String[] cellValues = values[i].split(",");
                CellTower tower = new CellTower();
                tower.setCellId(Long.parseLong(cellValues[0]));
                tower.setLocationAreaCode(Integer.parseInt(cellValues[1]));
                tower.setMobileNetworkCode(Integer.parseInt(cellValues[2]));
                tower.setMobileCountryCode(Integer.parseInt(cellValues[3]));
                tower.setSignalStrength(Integer.parseInt(cellValues[4]));
                network.addCellTower(tower);
            }
            position.setNetwork(network);
        } else {
            position.setValid(true);
            position.setFixTime(position.getDeviceTime());
            position.setLatitude(Double.parseDouble(values[0]));
            position.setLongitude(Double.parseDouble(values[1]));
        }
        return position;
    }
}

