/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.List;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class PathAwayProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$PWS,").number("d+,").expression("[^,]*,").expression("[^,]*,").expression("[^,]*,").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(-?d+.?d*),").number("(-?d+.?d*),").number("(-?d+.?d*),").any().compile();

    public PathAwayProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, (String)((List)decoder.parameters().get("UserName")).get(0));
        if (deviceSession == null) {
            return null;
        }
        Parser parser = new Parser(PATTERN, (String)((List)decoder.parameters().get("LOC")).get(0));
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setValid(true);
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        if (channel != null) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return position;
    }
}

