/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Introspector;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.traccar.helper.ClassScanner;
import org.traccar.model.BaseModel;
import org.traccar.storage.QueryIgnore;

public class Permission {
    private static final Map<String, Class<? extends BaseModel>> CLASSES = new TreeMap<String, Class<? extends BaseModel>>(String.CASE_INSENSITIVE_ORDER);
    private final LinkedHashMap<String, Long> data;
    private final Class<? extends BaseModel> ownerClass;
    private final long ownerId;
    private final Class<? extends BaseModel> propertyClass;
    private final long propertyId;

    public Permission(LinkedHashMap<String, Long> data) {
        this.data = data;
        Iterator<Map.Entry<String, Long>> iterator = data.entrySet().iterator();
        Map.Entry<String, Long> owner = iterator.next();
        this.ownerClass = Permission.getKeyClass(owner.getKey());
        this.ownerId = owner.getValue();
        Map.Entry<String, Long> property = iterator.next();
        this.propertyClass = Permission.getKeyClass(property.getKey());
        this.propertyId = property.getValue();
    }

    public Permission(Class<? extends BaseModel> ownerClass, long ownerId, Class<? extends BaseModel> propertyClass, long propertyId) {
        this.ownerClass = ownerClass;
        this.ownerId = ownerId;
        this.propertyClass = propertyClass;
        this.propertyId = propertyId;
        this.data = new LinkedHashMap();
        this.data.put(Permission.getKey(ownerClass), ownerId);
        this.data.put(Permission.getKey(propertyClass), propertyId);
    }

    public static Class<? extends BaseModel> getKeyClass(String key) {
        return CLASSES.get(key.substring(0, key.length() - 2));
    }

    public static String getKey(Class<?> clazz) {
        return Introspector.decapitalize(clazz.getSimpleName()) + "Id";
    }

    public static String getStorageName(Class<?> ownerClass, Class<?> propertyClass) {
        String managedPrefix;
        String ownerName = ownerClass.getSimpleName();
        String propertyName = propertyClass.getSimpleName();
        if (propertyName.startsWith(managedPrefix = "Managed")) {
            propertyName = propertyName.substring(managedPrefix.length());
        }
        return "tc_" + Introspector.decapitalize(ownerName) + "_" + Introspector.decapitalize(propertyName);
    }

    @QueryIgnore
    @JsonIgnore
    public String getStorageName() {
        return Permission.getStorageName(this.ownerClass, this.propertyClass);
    }

    @QueryIgnore
    @JsonAnyGetter
    public Map<String, Long> get() {
        return this.data;
    }

    @QueryIgnore
    @JsonAnySetter
    public void set(String key, Long value) {
        this.data.put(key, value);
    }

    @QueryIgnore
    @JsonIgnore
    public Class<? extends BaseModel> getOwnerClass() {
        return this.ownerClass;
    }

    @QueryIgnore
    @JsonIgnore
    public long getOwnerId() {
        return this.ownerId;
    }

    @QueryIgnore
    @JsonIgnore
    public Class<? extends BaseModel> getPropertyClass() {
        return this.propertyClass;
    }

    @QueryIgnore
    @JsonIgnore
    public long getPropertyId() {
        return this.propertyId;
    }

    static {
        try {
            for (Class<?> clazz : ClassScanner.findSubclasses(BaseModel.class)) {
                CLASSES.put(clazz.getSimpleName(), clazz);
            }
        }
        catch (IOException | ReflectiveOperationException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

