/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.model.Event;
import org.traccar.model.Position;

public abstract class BaseEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseEventHandler.class);

    public void analyzePosition(Position position, Callback callback) {
        try {
            this.onPosition(position, callback);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Event handler failed", (Throwable)e);
        }
    }

    public abstract void onPosition(Position var1, Callback var2);

    public static interface Callback {
        public void eventDetected(Event var1);
    }
}

