/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.AbstractExtension;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OutgoingEntry;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.util.DemandChain;
import org.eclipse.jetty.websocket.core.util.FragmentingFlusher;
import org.eclipse.jetty.websocket.core.util.WebSocketDemander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentExtension
extends AbstractExtension
implements DemandChain {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentExtension.class);
    private final FragmentingFlusher outgoingFlusher;
    private final WebSocketDemander incomingFlusher;
    private final Configuration configuration = new Configuration.ConfigurationCustomizer();

    public FragmentExtension() {
        this.outgoingFlusher = new FragmentingFlusher(this.configuration){

            @Override
            protected void forwardFrame(OutgoingEntry entry) {
                FragmentExtension.this.nextOutgoingFrame(entry);
            }
        };
        this.incomingFlusher = new FragmentingDemander();
    }

    @Override
    public void demand() {
        this.incomingFlusher.demand();
    }

    @Override
    public void setNextDemand(DemandChain nextDemand) {
        this.incomingFlusher.setNextDemand(nextDemand);
    }

    @Override
    public String getName() {
        return "fragment";
    }

    @Override
    public void onFrame(Frame frame, Callback callback) {
        this.incomingFlusher.onFrame(frame, callback);
    }

    @Override
    public void sendFrame(OutgoingEntry entry) {
        this.outgoingFlusher.sendFrame(entry);
    }

    @Override
    public void init(ExtensionConfig config, WebSocketComponents components) {
        super.init(config, components);
        int maxLength = config.getParameter("maxLength", -1);
        this.configuration.setMaxFrameSize(maxLength);
    }

    public class FragmentingDemander
    extends WebSocketDemander {
        private ByteBuffer _payload;

        public FragmentingDemander() {
            super((Frame x$0, Callback x$1) -> FragmentExtension.this.nextIncomingFrame(x$0, x$1));
        }

        @Override
        protected boolean handle(Frame frame, Callback callback, boolean first) {
            long maxFrameSize = FragmentExtension.this.configuration.getMaxFrameSize();
            if (first) {
                if (frame.isControlFrame() || maxFrameSize <= 0L || (long)frame.getPayloadLength() <= maxFrameSize) {
                    this.emitFrame(frame, callback);
                    return true;
                }
                this._payload = frame.getPayload();
            }
            int remaining = this._payload.remaining();
            int fragmentSize = (int)Math.min((long)remaining, maxFrameSize);
            byte opCode = frame.getOpCode() == 0 || !first ? (byte)0 : frame.getOpCode();
            Frame fragment = new Frame(opCode);
            boolean finished = maxFrameSize <= 0L || (long)remaining <= maxFrameSize;
            fragment.setFin(frame.isFin() && finished);
            if (finished) {
                fragment.setPayload(this._payload);
                this._payload = null;
            } else {
                int limit = this._payload.limit();
                int newLimit = this._payload.position() + fragmentSize;
                this._payload.limit(newLimit);
                ByteBuffer payloadFragment = this._payload.slice();
                this._payload.limit(limit);
                fragment.setPayload(payloadFragment);
                this._payload.position(newLimit);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Fragmented {}->{}", (Object)frame, (Object)fragment);
                }
            }
            Callback payloadCallback = Callback.from(() -> {
                if (finished) {
                    callback.succeeded();
                }
            }, t -> {
                callback.failed(t);
                this.failFlusher((Throwable)t);
            });
            this.emitFrame(fragment, payloadCallback);
            return finished;
        }

        @Override
        protected void onCompleteFailure(Throwable cause) {
            super.onCompleteFailure(cause);
            this._payload = null;
        }
    }
}

