/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.GroupServiceClient;
import com.google.cloud.monitoring.v3.stub.GroupServiceStub;
import com.google.cloud.monitoring.v3.stub.GroupServiceStubSettings;
import com.google.cloud.monitoring.v3.stub.GrpcGroupServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcGroupServiceStub
extends GroupServiceStub {
    private static final MethodDescriptor<ListGroupsRequest, ListGroupsResponse> listGroupsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.GroupService/ListGroups").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGroupsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGroupsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetGroupRequest, Group> getGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.GroupService/GetGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Group.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateGroupRequest, Group> createGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.GroupService/CreateGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Group.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateGroupRequest, Group> updateGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.GroupService/UpdateGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Group.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteGroupRequest, Empty> deleteGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.GroupService/DeleteGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.monitoring.v3.GroupService/ListGroupMembers").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGroupMembersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGroupMembersResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable;
    private final UnaryCallable<ListGroupsRequest, GroupServiceClient.ListGroupsPagedResponse> listGroupsPagedCallable;
    private final UnaryCallable<GetGroupRequest, Group> getGroupCallable;
    private final UnaryCallable<CreateGroupRequest, Group> createGroupCallable;
    private final UnaryCallable<UpdateGroupRequest, Group> updateGroupCallable;
    private final UnaryCallable<DeleteGroupRequest, Empty> deleteGroupCallable;
    private final UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable;
    private final UnaryCallable<ListGroupMembersRequest, GroupServiceClient.ListGroupMembersPagedResponse> listGroupMembersPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcGroupServiceStub create(GroupServiceStubSettings settings) throws IOException {
        return new GrpcGroupServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcGroupServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcGroupServiceStub(GroupServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcGroupServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcGroupServiceStub(GroupServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcGroupServiceStub(GroupServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcGroupServiceCallableFactory());
    }

    protected GrpcGroupServiceStub(GroupServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listGroupsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGroupsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("group.name", String.valueOf(request.getGroup().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listGroupMembersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGroupMembersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listGroupsCallable = callableFactory.createUnaryCallable(listGroupsTransportSettings, settings.listGroupsSettings(), clientContext);
        this.listGroupsPagedCallable = callableFactory.createPagedCallable(listGroupsTransportSettings, settings.listGroupsSettings(), clientContext);
        this.getGroupCallable = callableFactory.createUnaryCallable(getGroupTransportSettings, settings.getGroupSettings(), clientContext);
        this.createGroupCallable = callableFactory.createUnaryCallable(createGroupTransportSettings, settings.createGroupSettings(), clientContext);
        this.updateGroupCallable = callableFactory.createUnaryCallable(updateGroupTransportSettings, settings.updateGroupSettings(), clientContext);
        this.deleteGroupCallable = callableFactory.createUnaryCallable(deleteGroupTransportSettings, settings.deleteGroupSettings(), clientContext);
        this.listGroupMembersCallable = callableFactory.createUnaryCallable(listGroupMembersTransportSettings, settings.listGroupMembersSettings(), clientContext);
        this.listGroupMembersPagedCallable = callableFactory.createPagedCallable(listGroupMembersTransportSettings, settings.listGroupMembersSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.listGroupsCallable;
    }

    @Override
    public UnaryCallable<ListGroupsRequest, GroupServiceClient.ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.listGroupsPagedCallable;
    }

    @Override
    public UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.getGroupCallable;
    }

    @Override
    public UnaryCallable<CreateGroupRequest, Group> createGroupCallable() {
        return this.createGroupCallable;
    }

    @Override
    public UnaryCallable<UpdateGroupRequest, Group> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    @Override
    public UnaryCallable<DeleteGroupRequest, Empty> deleteGroupCallable() {
        return this.deleteGroupCallable;
    }

    @Override
    public UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable() {
        return this.listGroupMembersCallable;
    }

    @Override
    public UnaryCallable<ListGroupMembersRequest, GroupServiceClient.ListGroupMembersPagedResponse> listGroupMembersPagedCallable() {
        return this.listGroupMembersPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

