/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ShareGroupHeartbeatResponse
extends AbstractResponse {
    private final ShareGroupHeartbeatResponseData data;

    public ShareGroupHeartbeatResponse(ShareGroupHeartbeatResponseData data) {
        super(ApiKeys.SHARE_GROUP_HEARTBEAT);
        this.data = data;
    }

    @Override
    public ShareGroupHeartbeatResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ShareGroupHeartbeatResponse parse(Readable readable, short version) {
        return new ShareGroupHeartbeatResponse(new ShareGroupHeartbeatResponseData(readable, version));
    }

    public static ShareGroupHeartbeatResponseData.Assignment createAssignment(Map<Uuid, Set<Integer>> assignment) {
        List<ShareGroupHeartbeatResponseData.TopicPartitions> topicPartitions = assignment.entrySet().stream().map(keyValue -> new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId((Uuid)keyValue.getKey()).setPartitions(new ArrayList<Integer>((Collection)keyValue.getValue()))).collect(Collectors.toList());
        return new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(topicPartitions);
    }
}

