/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.DefaultBufferedWritableByteChannel;
import com.google.cloud.storage.MinFlushBufferedWritableByteChannel;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@BetaApi
@InternalExtensionOnly
@Immutable
public abstract class FlushPolicy {
    private FlushPolicy() {
    }

    @BetaApi
    public static MaxFlushSizeFlushPolicy maxFlushSize() {
        return MaxFlushSizeFlushPolicy.INSTANCE;
    }

    @BetaApi
    public static MaxFlushSizeFlushPolicy maxFlushSize(int maxFlushSize) {
        return FlushPolicy.maxFlushSize().withMaxFlushSize(maxFlushSize);
    }

    @BetaApi
    public static MinFlushSizeFlushPolicy minFlushSize() {
        return MinFlushSizeFlushPolicy.INSTANCE;
    }

    @BetaApi
    public static MinFlushSizeFlushPolicy minFlushSize(int minFlushSize) {
        return FlushPolicy.minFlushSize().withMinFlushSize(minFlushSize);
    }

    abstract BufferedWritableByteChannelSession.BufferedWritableByteChannel createBufferedChannel(UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel var1, boolean var2);

    abstract long getMaxPendingBytes();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @BetaApi
    @Immutable
    public static final class MaxFlushSizeFlushPolicy
    extends FlushPolicy {
        private static final MaxFlushSizeFlushPolicy INSTANCE = new MaxFlushSizeFlushPolicy(0x200000);
        private final int maxFlushSize;

        private MaxFlushSizeFlushPolicy(int maxFlushSize) {
            this.maxFlushSize = maxFlushSize;
        }

        @BetaApi
        public int getMaxFlushSize() {
            return this.maxFlushSize;
        }

        @BetaApi
        public MaxFlushSizeFlushPolicy withMaxFlushSize(int maxFlushSize) {
            Preconditions.checkArgument((maxFlushSize >= 0 ? 1 : 0) != 0, (String)"maxFlushSize >= 0 (%s >= 0)", (int)maxFlushSize);
            if (this.maxFlushSize == maxFlushSize) {
                return this;
            }
            return new MaxFlushSizeFlushPolicy(maxFlushSize);
        }

        @Override
        BufferedWritableByteChannelSession.BufferedWritableByteChannel createBufferedChannel(UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel unbuffered, boolean blocking) {
            return new DefaultBufferedWritableByteChannel(BufferHandle.allocate(this.maxFlushSize), unbuffered, blocking);
        }

        @Override
        long getMaxPendingBytes() {
            return this.maxFlushSize;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MaxFlushSizeFlushPolicy)) {
                return false;
            }
            MaxFlushSizeFlushPolicy that = (MaxFlushSizeFlushPolicy)o;
            return this.maxFlushSize == that.maxFlushSize;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.maxFlushSize);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("maxFlushSize", this.maxFlushSize).toString();
        }
    }

    @BetaApi
    @Immutable
    public static final class MinFlushSizeFlushPolicy
    extends FlushPolicy {
        private static final MinFlushSizeFlushPolicy INSTANCE = new MinFlushSizeFlushPolicy(0x400000, 0x1000000L);
        private final int minFlushSize;
        private final long maxPendingBytes;

        private MinFlushSizeFlushPolicy(int minFlushSize, long maxPendingBytes) {
            this.minFlushSize = minFlushSize;
            this.maxPendingBytes = maxPendingBytes;
        }

        @BetaApi
        public int getMinFlushSize() {
            return this.minFlushSize;
        }

        @BetaApi
        public MinFlushSizeFlushPolicy withMinFlushSize(int minFlushSize) {
            Preconditions.checkArgument((minFlushSize >= 0 ? 1 : 0) != 0, (String)"minFlushSize >= 0 (%s >= 0)", (int)minFlushSize);
            if (this.minFlushSize == minFlushSize) {
                return this;
            }
            return new MinFlushSizeFlushPolicy(minFlushSize, this.maxPendingBytes);
        }

        @Override
        @BetaApi
        public long getMaxPendingBytes() {
            return this.maxPendingBytes;
        }

        @BetaApi
        public MinFlushSizeFlushPolicy withMaxPendingBytes(long maxPendingBytes) {
            Preconditions.checkArgument((maxPendingBytes >= 0L ? 1 : 0) != 0, (String)"maxPendingBytes >= 0 (%s >= 0)", (long)maxPendingBytes);
            Preconditions.checkArgument((maxPendingBytes >= (long)this.minFlushSize ? 1 : 0) != 0, (String)"maxPendingBytes >= minFlushSize (%s >= %s", (long)maxPendingBytes, (int)this.minFlushSize);
            if (this.maxPendingBytes == maxPendingBytes) {
                return this;
            }
            return new MinFlushSizeFlushPolicy(this.minFlushSize, maxPendingBytes);
        }

        @Override
        BufferedWritableByteChannelSession.BufferedWritableByteChannel createBufferedChannel(UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel unbuffered, boolean blocking) {
            return new MinFlushBufferedWritableByteChannel(BufferHandle.allocate(this.minFlushSize), unbuffered, blocking);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MinFlushSizeFlushPolicy)) {
                return false;
            }
            MinFlushSizeFlushPolicy that = (MinFlushSizeFlushPolicy)o;
            return this.minFlushSize == that.minFlushSize && this.maxPendingBytes == that.maxPendingBytes;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.minFlushSize, this.maxPendingBytes);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("minFlushSize", this.minFlushSize).add("maxPendingBytes", this.maxPendingBytes).toString();
        }
    }
}

