/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Locale;
import liqp.LValue;
import liqp.TemplateContext;
import liqp.filters.Filter;
import liqp.filters.date.CustomDateFormatRegistry;
import liqp.filters.date.CustomDateFormatSupport;
import liqp.filters.date.Parser;
import ua.co.k.strftime.StrftimeFormatter;

public class Date
extends Filter {
    protected Date() {
    }

    protected Date(CustomDateFormatSupport typeSupport) {
        CustomDateFormatRegistry.add(typeSupport);
    }

    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        Locale locale = context.renderSettings.locale;
        if (this.isArray(value) && this.asArray(value, context).length == 1) {
            value = this.asArray(value, context)[0];
        }
        try {
            ZonedDateTime compatibleDate = "now".equals(super.asString(value, context)) || "today".equals(super.asString(value, context)) ? ZonedDateTime.now() : (LValue.isTemporal(value) ? LValue.asTemporal(value, context) : (super.isNumber(value) ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(super.asNumber(value).longValue() * 1000L), context.renderSettings.defaultTimeZone) : Parser.parse(super.asString(value, context), locale, context.renderSettings.defaultTimeZone)));
            if (compatibleDate == null) {
                return value;
            }
            String format = super.asString(super.get(0, params), context);
            if (format == null || format.trim().isEmpty()) {
                return value;
            }
            StrftimeFormatter formatter = StrftimeFormatter.ofSafePattern((String)format, (Locale)locale);
            return formatter.format((Object)compatibleDate);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static void addDatePattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("date-pattern cannot be null");
        }
        Parser.datePatterns.add(pattern);
    }

    public static void removeDatePattern(String pattern) {
        Parser.datePatterns.remove(pattern);
    }

    public static Filter withCustomDateType(CustomDateFormatSupport typeSupport) {
        return new Date(typeSupport);
    }
}

