/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public final class NokogiriNamespaceContext
implements NamespaceContext {
    public static final String NOKOGIRI_PREFIX = "nokogiri";
    public static final String NOKOGIRI_URI = "http://www.nokogiri.org/default_ns/ruby/extensions_functions";
    public static final String NOKOGIRI_BUILTIN_PREFIX = "nokogiri-builtin";
    public static final String NOKOGIRI_BUILTIN_URI = "https://www.nokogiri.org/default_ns/ruby/builtins";
    private final Map<String, String> register = new HashMap<String, String>(6, 1.0f);

    public static NokogiriNamespaceContext create() {
        return new NokogiriNamespaceContext();
    }

    private NokogiriNamespaceContext() {
        this.register.put(NOKOGIRI_PREFIX, NOKOGIRI_URI);
        this.register.put(NOKOGIRI_BUILTIN_PREFIX, NOKOGIRI_BUILTIN_URI);
        this.register.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.register.put("xhtml", "http://www.w3.org/1999/xhtml");
    }

    @Override
    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = this.register.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.equals("xmlns")) {
            string2 = this.register.get("xmlns");
            return string2 == null ? "http://www.w3.org/2000/xmlns/" : string2;
        }
        return "";
    }

    @Override
    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("uri is null");
        }
        Set<Map.Entry<String, String>> set = this.register.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (!string.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        Set<Map.Entry<String, String>> set = this.register.entrySet();
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        for (Map.Entry<String, String> entry : set) {
            if (!string.equals(entry.getValue())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.iterator();
    }

    public Set<String> getAllPrefixes() {
        return this.register.keySet();
    }

    public void registerNamespace(String string, String string2) {
        if ("xmlns".equals(string)) {
            string = "";
        }
        this.register.put(string, string2);
    }

    public void deregisterNamespace(String string) {
        if ("xmlns".equals(string)) {
            string = "";
        }
        this.register.remove(string);
    }
}

