/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.optional;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.vti.ForeignTableVTI;

public class ForeignDBViews
implements OptionalTool {
    private static final int XML_TYPE = 2009;
    private static final String[] SAFE_DROP_SQLSTATES = new String[]{"X0X05.S", "42Y55", "42Y07"};

    public void loadTool(String ... configurationParameters) throws SQLException {
        if (configurationParameters == null || configurationParameters.length < 1) {
            throw this.wrap(LocalizedResource.getMessage("OT_BadLoadUnloadArgs", new Object[0]));
        }
        String foreignConnectionURL = configurationParameters[0];
        String schemaPrefix = configurationParameters.length == 1 ? null : configurationParameters[1];
        Connection foreignConn = this.getForeignConnection(foreignConnectionURL);
        Connection derbyConn = this.getDerbyConnection();
        DatabaseMetaData foreignDBMD = foreignConn.getMetaData();
        ResultSet tableCursor = this.getForeignTables(foreignDBMD);
        while (tableCursor.next()) {
            this.registerForeignTable(foreignDBMD, tableCursor.getString(2), tableCursor.getString(3), foreignConnectionURL, schemaPrefix, derbyConn);
        }
        tableCursor.close();
        foreignConn.close();
    }

    public void unloadTool(String ... configurationParameters) throws SQLException {
        if (configurationParameters == null || configurationParameters.length < 1) {
            throw this.wrap(LocalizedResource.getMessage("OT_BadLoadUnloadArgs", new Object[0]));
        }
        String foreignConnectionURL = configurationParameters[0];
        String schemaPrefix = configurationParameters.length == 1 ? null : configurationParameters[1];
        Connection foreignConn = this.getForeignConnection(foreignConnectionURL);
        Connection derbyConn = this.getDerbyConnection();
        DatabaseMetaData foreignDBMD = foreignConn.getMetaData();
        ResultSet tableCursor = this.getForeignTables(foreignDBMD);
        HashSet<String> schemas = new HashSet<String>();
        while (tableCursor.next()) {
            String derbySchemaName = this.getDerbySchemaName(schemaPrefix, tableCursor.getString(2));
            String objectName = tableCursor.getString(3);
            if (derbySchemaName != null) {
                schemas.add(derbySchemaName);
            }
            this.dropObject(derbyConn, derbySchemaName, objectName, "view", false);
            this.dropObject(derbyConn, derbySchemaName, objectName, "function", false);
        }
        tableCursor.close();
        foreignConn.close();
        for (String schemaName : schemas) {
            this.dropDerbySchema(derbyConn, schemaName);
        }
        ForeignTableVTI.dropConnection((String)foreignConnectionURL);
    }

    private void registerForeignTable(DatabaseMetaData foreignDBMD, String foreignSchemaName, String foreignTableName, String foreignConnectionURL, String schemaPrefix, Connection derbyConn) throws SQLException {
        StringBuilder tfBuffer = new StringBuilder();
        String derbySchemaName = this.getDerbySchemaName(schemaPrefix, foreignSchemaName);
        String dotSchemaName = this.dotSeparatedSchemaName(derbySchemaName);
        this.createDerbySchema(derbyConn, derbySchemaName);
        tfBuffer.append("create function " + dotSchemaName + this.delimitedID(foreignTableName));
        tfBuffer.append("\n(");
        tfBuffer.append("\n\tforeignSchemaName varchar( 32672 ),");
        tfBuffer.append("\n\tforeignTableName varchar( 32672 ),");
        tfBuffer.append("\n\tconnectionURL varchar( 32672 )");
        tfBuffer.append("\n)\nreturns table\n(");
        ResultSet columnCursor = foreignDBMD.getColumns(null, foreignSchemaName, foreignTableName, "%");
        int columnCount = 0;
        while (columnCursor.next()) {
            tfBuffer.append("\n\t");
            if (columnCount > 0) {
                tfBuffer.append(", ");
            }
            ++columnCount;
            tfBuffer.append(this.delimitedID(columnCursor.getString(4)));
            tfBuffer.append(" ");
            tfBuffer.append(this.mapType(columnCursor.getInt(5), columnCursor.getInt(7), columnCursor.getInt(9), columnCursor.getString(6)));
        }
        columnCursor.close();
        tfBuffer.append("\n)");
        tfBuffer.append("\nlanguage java parameter style derby_jdbc_result_set no sql");
        tfBuffer.append("\nexternal name 'org.apache.derby.vti.ForeignTableVTI.readForeignTable'");
        String tfDDL = tfBuffer.toString();
        StringBuilder viewBuffer = new StringBuilder();
        viewBuffer.append("create view " + dotSchemaName + this.delimitedID(foreignTableName));
        viewBuffer.append("\nas select *");
        viewBuffer.append("\nfrom table");
        viewBuffer.append("\n(\n");
        viewBuffer.append("\t" + dotSchemaName + this.delimitedID(foreignTableName));
        viewBuffer.append("\n\t(");
        viewBuffer.append("\n\t\t" + this.stringLiteral(foreignSchemaName) + ",");
        viewBuffer.append("\n\t\t" + this.stringLiteral(foreignTableName) + ",");
        viewBuffer.append("\n\t\t" + this.stringLiteral(foreignConnectionURL));
        viewBuffer.append("\n\t)");
        viewBuffer.append("\n) s");
        String viewDDL = viewBuffer.toString();
        this.executeDDL(derbyConn, tfDDL);
        this.executeDDL(derbyConn, viewDDL);
    }

    private ResultSet getForeignTables(DatabaseMetaData foreignDBMD) throws SQLException {
        return foreignDBMD.getTables(null, null, "%", new String[]{"TABLE"});
    }

    private void createDerbySchema(Connection derbyConn, String derbySchemaName) throws SQLException {
        if (derbySchemaName == null) {
            return;
        }
        PreparedStatement existsPS = this.prepareStatement(derbyConn, "select count(*) from sys.sysschemas where schemaname = ?");
        existsPS.setString(1, derbySchemaName);
        ResultSet existsRS = existsPS.executeQuery();
        existsRS.next();
        boolean exists = existsRS.getInt(1) > 0;
        existsRS.close();
        existsPS.close();
        if (!exists) {
            this.executeDDL(derbyConn, "create schema " + this.delimitedID(derbySchemaName));
        }
    }

    private void dropDerbySchema(Connection derbyConn, String derbySchemaName) throws SQLException {
        if (derbySchemaName == null) {
            return;
        }
        this.dropObject(derbyConn, null, derbySchemaName, "schema", true);
    }

    private String getDerbySchemaName(String schemaPrefix, String foreignSchemaName) {
        if (foreignSchemaName == null) {
            return null;
        }
        if (schemaPrefix == null) {
            return foreignSchemaName;
        }
        return schemaPrefix + foreignSchemaName;
    }

    private String dotSeparatedSchemaName(String rawName) {
        if (rawName == null) {
            return "";
        }
        return this.delimitedID(rawName) + ".";
    }

    private String mapType(int jdbcType, int precision, int scale, String foreignTypeName) throws SQLException {
        switch (jdbcType) {
            case -5: {
                return "bigint";
            }
            case -2: {
                return "char " + this.precisionToLength(precision) + "  for bit data";
            }
            case -7: {
                return "boolean";
            }
            case 2004: {
                return "blob";
            }
            case 16: {
                return "boolean";
            }
            case 1: {
                return "char" + this.precisionToLength(precision);
            }
            case 2005: {
                return "clob";
            }
            case 91: {
                return "date";
            }
            case 3: {
                return "decimal" + this.precisionAndScale(precision, scale);
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 4: {
                return "integer";
            }
            case -4: {
                return "long varchar for bit data";
            }
            case -1: {
                return "long varchar";
            }
            case 2: {
                return "numeric" + this.precisionAndScale(precision, scale);
            }
            case 7: {
                return "real";
            }
            case 5: {
                return "smallint";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "smallint";
            }
            case -3: {
                return "varchar " + this.precisionToLength(precision) + "  for bit data";
            }
            case 12: {
                return "varchar" + this.precisionToLength(precision);
            }
            case 2009: {
                return "xml";
            }
        }
        throw this.wrap(LocalizedResource.getMessage("OT_UnknownForeignDataType", Integer.toString(jdbcType), foreignTypeName));
    }

    private String precisionToLength(int precision) {
        return "( " + precision + " )";
    }

    private String precisionAndScale(int precision, int scale) {
        return "( " + precision + ", " + scale + " )";
    }

    private void dropObject(Connection conn, String schemaName, String objectName, String objectType, boolean restrict) throws SQLException {
        String dotSchemaName = this.dotSeparatedSchemaName(schemaName);
        String restrictString = restrict ? " restrict" : "";
        try {
            this.executeDDL(conn, "drop " + objectType + " " + dotSchemaName + this.delimitedID(objectName) + restrictString);
        }
        catch (SQLException se) {
            String actualSQLState = se.getSQLState();
            for (String safeSQLState : SAFE_DROP_SQLSTATES) {
                if (!actualSQLState.startsWith(safeSQLState)) continue;
                return;
            }
            throw se;
        }
    }

    private Connection getForeignConnection(String connectionURL) throws SQLException {
        return DriverManager.getConnection(connectionURL);
    }

    private Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private String delimitedID(String text) {
        return IdUtil.normalToDelimited((String)text);
    }

    private String stringLiteral(String text) {
        return StringUtil.quoteStringLiteral((String)text);
    }

    private void executeDDL(Connection conn, String text) throws SQLException {
        PreparedStatement ddl = this.prepareStatement(conn, text);
        ddl.execute();
        ddl.close();
    }

    private PreparedStatement prepareStatement(Connection conn, String text) throws SQLException {
        return conn.prepareStatement(text);
    }

    private SQLException wrap(String errorMessage) {
        String sqlState = "XJ001.U".substring(0, 5);
        return new SQLException(errorMessage, sqlState);
    }
}

