/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.WrapperKeySerializerConfig;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class WrapperKeySerializer<T>
implements Serializer<T> {
    private Serializer<T> inner;

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new WrapperKeySerializerConfig(configs), isKey);
    }

    protected void configure(WrapperKeySerializerConfig config, boolean isKey) {
        if (!isKey) {
            throw new IllegalArgumentException("WrapperKeySerializer is only for keys");
        }
        this.inner = (Serializer)config.getConfiguredInstance("wrapped.key.serializer", Serializer.class);
        this.inner.configure(config.originals(), isKey);
    }

    public byte[] serialize(String topic, T data) {
        return this.serialize(topic, null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(String topic, Headers headers, T data) {
        try {
            byte[] byArray = this.inner.serialize(topic, headers, data);
            return byArray;
        }
        finally {
            AbstractKafkaSchemaSerDe.setKey(data);
        }
    }

    public void close() {
        this.inner.close();
    }
}

