/*
 * Decompiled with CFR 0.152.
 */
package rx;

import rx.Observer;
import rx.Producer;
import rx.Subscription;
import rx.internal.util.SubscriptionList;

public abstract class Subscriber<T>
implements Observer<T>,
Subscription {
    private static final long NOT_SET = Long.MIN_VALUE;
    private final SubscriptionList subscriptions;
    private final Subscriber<?> subscriber;
    private Producer producer;
    private long requested = Long.MIN_VALUE;

    protected Subscriber() {
        this(null, false);
    }

    protected Subscriber(Subscriber<?> subscriber) {
        this(subscriber, true);
    }

    protected Subscriber(Subscriber<?> subscriber, boolean shareSubscriptions) {
        this.subscriber = subscriber;
        this.subscriptions = shareSubscriptions && subscriber != null ? subscriber.subscriptions : new SubscriptionList();
    }

    public final void add(Subscription s) {
        this.subscriptions.add(s);
    }

    @Override
    public final void unsubscribe() {
        this.subscriptions.unsubscribe();
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.subscriptions.isUnsubscribed();
    }

    public void onStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void request(long n) {
        Producer producerToRequestFrom;
        if (n < 0L) {
            throw new IllegalArgumentException("number requested cannot be negative: " + n);
        }
        Subscriber subscriber = this;
        synchronized (subscriber) {
            if (this.producer == null) {
                this.addToRequested(n);
                return;
            }
            producerToRequestFrom = this.producer;
        }
        producerToRequestFrom.request(n);
    }

    private void addToRequested(long n) {
        long total;
        this.requested = this.requested == Long.MIN_VALUE ? n : ((total = this.requested + n) < 0L ? Long.MAX_VALUE : total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProducer(Producer p) {
        long toRequest;
        boolean passToSubscriber = false;
        Subscriber subscriber = this;
        synchronized (subscriber) {
            toRequest = this.requested;
            this.producer = p;
            if (this.subscriber != null && toRequest == Long.MIN_VALUE) {
                passToSubscriber = true;
            }
        }
        if (passToSubscriber) {
            this.subscriber.setProducer(this.producer);
        } else if (toRequest == Long.MIN_VALUE) {
            this.producer.request(Long.MAX_VALUE);
        } else {
            this.producer.request(toRequest);
        }
    }
}

